/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.oltu.commons.json;

import io.geewit.oltu.commons.json.CustomizableEntity;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import javax.json.Json;
import javax.json.stream.JsonGenerator;

public abstract class CustomizableEntityWriter<CE extends CustomizableEntity> {
    private final StringWriter stringWriter = new StringWriter();
    private final JsonGenerator generator = Json.createGenerator((Writer)this.stringWriter);

    public final String write(CE customizableEntity) {
        this.generator.writeStartObject();
        this.handleProperties(customizableEntity);
        for (Map.Entry<String, Object> customFields : ((CustomizableEntity)customizableEntity).getCustomFields()) {
            this.set(customFields.getKey(), customFields.getValue());
        }
        this.generator.writeEnd().close();
        return this.stringWriter.toString();
    }

    protected abstract void handleProperties(CE var1);

    protected final <T> void set(String key, T value) {
        if (key != null && value != null) {
            String string;
            if (value instanceof Boolean) {
                this.generator.write(key, ((Boolean)value).booleanValue());
            } else if (value instanceof Double) {
                this.generator.write(key, ((Double)value).doubleValue());
            } else if (value instanceof Integer) {
                this.generator.write(key, ((Integer)value).intValue());
            } else if (value instanceof BigDecimal) {
                this.generator.write(key, (BigDecimal)value);
            } else if (value instanceof BigInteger) {
                this.generator.write(key, (BigInteger)value);
            } else if (value instanceof Long) {
                this.generator.write(key, ((Long)value).longValue());
            } else if (value instanceof String && !(string = (String)value).isEmpty()) {
                this.generator.write(key, string);
            }
        }
    }

    protected final <T> void set(String key, T[] value) {
        if (value == null) {
            return;
        }
        this.generator.writeStartArray(key);
        for (T item : value) {
            if (item == null) continue;
            if (item instanceof Boolean) {
                this.generator.write(((Boolean)item).booleanValue());
                continue;
            }
            if (item instanceof Double) {
                this.generator.write(((Double)item).doubleValue());
                continue;
            }
            if (item instanceof Integer) {
                this.generator.write(((Integer)item).intValue());
                continue;
            }
            if (item instanceof BigDecimal) {
                this.generator.write((BigDecimal)item);
                continue;
            }
            if (item instanceof BigInteger) {
                this.generator.write((BigInteger)item);
                continue;
            }
            if (item instanceof Long) {
                this.generator.write(((Long)item).longValue());
                continue;
            }
            if (!(item instanceof String)) continue;
            this.generator.write((String)item);
        }
        this.generator.writeEnd();
    }
}

