/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.oltu.commons.json;

import io.geewit.oltu.commons.json.CustomizableBuilder;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public abstract class CustomizableEntityReader<E, B extends CustomizableBuilder<E>> {
    private final B builder;

    public CustomizableEntityReader(B builder) {
        this.builder = builder;
    }

    private static Object toJavaObject(JsonValue jsonValue) {
        Object[] value = null;
        switch (jsonValue.getValueType()) {
            case ARRAY: {
                JsonArray array = (JsonArray)jsonValue;
                Object[] values = new Object[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    JsonValue current = (JsonValue)array.get(i);
                    values[i] = CustomizableEntityReader.toJavaObject(current);
                }
                value = values;
                break;
            }
            case FALSE: {
                value = false;
                break;
            }
            case NULL: {
                value = null;
                break;
            }
            case NUMBER: {
                JsonNumber jsonNumber = (JsonNumber)jsonValue;
                value = jsonNumber.numberValue();
                break;
            }
            case OBJECT: {
                break;
            }
            case STRING: {
                JsonString jsonString = (JsonString)jsonValue;
                value = jsonString.getString();
                break;
            }
            case TRUE: {
                value = true;
                break;
            }
        }
        return value;
    }

    protected final B getBuilder() {
        return this.builder;
    }

    public void read(String jsonString) {
        if (jsonString == null) {
            throw new IllegalArgumentException("Null string does not represent a valid JSON object");
        }
        StringReader reader = new StringReader(jsonString);
        JsonReader jsonReader = Json.createReader((Reader)reader);
        JsonStructure structure = jsonReader.read();
        if (structure == null || structure instanceof JsonArray) {
            throw new IllegalArgumentException(String.format("String '%s' is not a valid JSON object representation", jsonString));
        }
        JsonObject object = (JsonObject)structure;
        for (Map.Entry entry : object.entrySet()) {
            Object value;
            String key = (String)entry.getKey();
            JsonValue jsonValue = (JsonValue)entry.getValue();
            if (jsonValue == null || this.handleProperty(key, value = CustomizableEntityReader.toJavaObject(jsonValue))) continue;
            ((CustomizableBuilder)this.builder).setCustomField(key, value);
        }
        jsonReader.close();
    }

    protected abstract <T> boolean handleProperty(String var1, T var2);
}

