/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.oltu.commons.json;

import java.util.Formatter;
import java.util.Map;
import java.util.Set;

public abstract class CustomizableEntity {
    private final Map<String, Object> customFields;

    public CustomizableEntity(Map<String, Object> customFields) {
        if (customFields == null) {
            throw new IllegalArgumentException("Null custom field registry not allowed.");
        }
        this.customFields = customFields;
    }

    public final <T> T getCustomField(String name, Class<T> type) {
        if (name == null) {
            throw new IllegalArgumentException("Null custom field name not present in the registry.");
        }
        Object value = this.customFields.get(name);
        if (value != null) {
            return type.cast(value);
        }
        return null;
    }

    public final Set<Map.Entry<String, Object>> getCustomFields() {
        return this.customFields.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.customFields.isEmpty()) {
            return "";
        }
        Formatter formatter = new Formatter();
        formatter.format(", ", new Object[0]);
        int counter = 0;
        for (Map.Entry<String, Object> customField : this.customFields.entrySet()) {
            Object value = customField.getValue();
            if (value == null) continue;
            if (counter++ > 0) {
                formatter.format(", ", new Object[0]);
            }
            String pattern = customField.getValue() instanceof Number ? "\"%s\": %s" : "\"%s\": \"%s\"";
            formatter.format(pattern, customField.getKey(), value);
        }
        try {
            String string = formatter.toString();
            return string;
        }
        finally {
            formatter.close();
        }
    }
}

