/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.repository.impl;

import io.geewit.data.jpa.essential.repository.JpaBatchRepository;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.transaction.annotation.Transactional;

public class SimpleJpaBatchRepository<T, ID>
extends SimpleJpaRepository<T, ID>
implements JpaBatchRepository<T, ID> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleJpaBatchRepository.class);
    private final EntityManager entityManager;
    private static final Integer BATCH_SIZE = 500;

    public SimpleJpaBatchRepository(JpaEntityInformation<T, ID> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.entityManager = entityManager;
        logger.debug("BATCH_SIZE = {}", (Object)BATCH_SIZE);
    }

    @Override
    @Transactional
    public List<T> saveBatch(Iterable<T> entities) {
        ArrayList<T> result = new ArrayList<T>();
        int i = 0;
        Iterator<T> iterator = entities.iterator();
        while (iterator.hasNext()) {
            T entity = iterator.next();
            this.entityManager.persist(entity);
            if (++i % BATCH_SIZE == 0 || !iterator.hasNext()) {
                logger.info("Flushing the EntityManager containing {} entities ...", (Object)i);
                this.entityManager.flush();
                this.entityManager.clear();
                i = 0;
            }
            result.add(entity);
        }
        logger.info("Flushing the remaining entities ...");
        return result;
    }
}

