/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.search;

import io.geewit.core.exception.ProcessedException;
import io.geewit.data.jpa.essential.search.Operator;
import io.geewit.data.jpa.essential.search.SearchFilter;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.NumberUtils;

public class DynamicSpecifications {
    private static final Logger logger = LoggerFactory.getLogger(DynamicSpecifications.class);
    private static final String[] PATTERNS = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "HH:mm:ss"};

    public static <T> Specification<T> bySearchFilter(Collection<SearchFilter> filters) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            if (filters != null && !filters.isEmpty()) {
                logger.debug("filters != null");
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                block16: for (SearchFilter filter : filters) {
                    Path path;
                    if (logger.isDebugEnabled()) {
                        logger.debug("filter.fieldName = " + filter.fieldName());
                        logger.debug("filter.values = " + StringUtils.join((Object[])filter.values(), (String)","));
                        logger.debug("filter.operator = " + filter.operator());
                        logger.debug("root.model = " + root.getModel().getName());
                    }
                    if (StringUtils.contains((CharSequence)filter.fieldName(), (int)36)) {
                        String[] fields = StringUtils.split((String)filter.fieldName(), (char)'$');
                        path = root.get(fields[0]);
                        for (int i = 1; i < fields.length && (path = path.get(fields[i])) != null; ++i) {
                        }
                    } else {
                        path = root.get(filter.fieldName());
                    }
                    if (path == null) break;
                    switch (filter.operator()) {
                        case EQ: {
                            Object value;
                            logger.debug("case EQ");
                            if (filter.values() == null || filter.values().length <= 0 || (value = DynamicSpecifications.parseValue(path, filter.values()[0])) == null) continue block16;
                            predicates.add(criteriaBuilder.equal((Expression)path, value));
                            break;
                        }
                        case NE: {
                            Object value;
                            logger.debug("case NE");
                            if (filter.values() == null || filter.values().length <= 0 || (value = DynamicSpecifications.parseValue(path, filter.values()[0])) == null) continue block16;
                            predicates.add(criteriaBuilder.notEqual((Expression)path, value));
                            break;
                        }
                        case LIKE: {
                            String like;
                            logger.debug("case LIKE");
                            if (filter.values() == null || filter.values().length <= 0 || !StringUtils.isNotEmpty((CharSequence)(like = filter.values()[0] instanceof String ? (String)filter.values()[0] : filter.values()[0].toString()))) continue block16;
                            predicates.add(criteriaBuilder.like((Expression)path, "%" + like + "%"));
                            break;
                        }
                        case LLIKE: {
                            String like;
                            logger.debug("case LLIKE");
                            if (filter.values() == null || filter.values().length <= 0 || !StringUtils.isNotEmpty((CharSequence)(like = filter.values()[0] instanceof String ? (String)filter.values()[0] : filter.values()[0].toString()))) continue block16;
                            predicates.add(criteriaBuilder.like((Expression)path, "%" + like));
                            break;
                        }
                        case RLIKE: {
                            String like;
                            logger.debug("case RLIKE");
                            if (filter.values() == null || filter.values().length <= 0 || !StringUtils.isNotEmpty((CharSequence)(like = filter.values()[0] instanceof String ? (String)filter.values()[0] : filter.values()[0].toString()))) continue block16;
                            predicates.add(criteriaBuilder.like((Expression)path, like + "%"));
                            break;
                        }
                        case GT: {
                            Object value;
                            logger.debug("case GT");
                            if (filter.values() == null || filter.values().length <= 0 || !((value = DynamicSpecifications.parseValue(path, filter.values()[0])) instanceof Comparable)) continue block16;
                            predicates.add(criteriaBuilder.greaterThan((Expression)path, (Comparable)value));
                            break;
                        }
                        case GTE: {
                            Object value;
                            logger.debug("case GTE");
                            if (filter.values() == null || filter.values().length <= 0 || !((value = DynamicSpecifications.parseValue(path, filter.values()[0])) instanceof Comparable)) continue block16;
                            predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)path, (Comparable)value));
                            break;
                        }
                        case LT: {
                            Object value;
                            logger.debug("case LT");
                            if (filter.values() == null || filter.values().length <= 0 || !((value = DynamicSpecifications.parseValue(path, filter.values()[0])) instanceof Comparable)) continue block16;
                            predicates.add(criteriaBuilder.lessThan((Expression)path, (Comparable)value));
                            break;
                        }
                        case LTE: {
                            Object value;
                            logger.debug("case LTE");
                            if (filter.values() == null || filter.values().length <= 0 || !((value = DynamicSpecifications.parseValue(path, filter.values()[0])) instanceof Comparable)) continue block16;
                            predicates.add(criteriaBuilder.lessThanOrEqualTo((Expression)path, (Comparable)value));
                            break;
                        }
                        case BETWEEN: {
                            Object[] values;
                            logger.debug("case BETWEEN");
                            if (filter.values().length != 2 || (values = DynamicSpecifications.parseValues(path, filter.operator(), filter.values())) == null || values.length != 2) continue block16;
                            if (values[0] != null && values[1] != null) {
                                predicates.add(criteriaBuilder.between((Expression)path, (Comparable)values[0], (Comparable)values[1]));
                                break;
                            }
                            if (values[0] != null) {
                                predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)path, (Comparable)values[0]));
                                break;
                            }
                            if (values[1] == null) continue block16;
                            predicates.add(criteriaBuilder.lessThanOrEqualTo((Expression)path, (Comparable)values[1]));
                            break;
                        }
                        case IN: {
                            logger.debug("case IN");
                            if (filter.values() == null || filter.values().length <= 0) continue block16;
                            Object[] values = DynamicSpecifications.parseValues(path, filter.operator(), filter.values());
                            predicates.add(path.in(values));
                            break;
                        }
                        case NOTIN: {
                            logger.debug("case NOTIN");
                            if (filter.values() == null || filter.values().length <= 0) continue block16;
                            Object[] values = DynamicSpecifications.parseValues(path, filter.operator(), filter.values());
                            predicates.add(criteriaBuilder.not((Expression)path.in(values)));
                            break;
                        }
                        case ISNULL: {
                            logger.debug("case IS NULL");
                            predicates.add(criteriaBuilder.isNull((Expression)path));
                            break;
                        }
                        case ISNOTNULL: {
                            logger.debug("case IS NOT NULL");
                            predicates.add(criteriaBuilder.isNotNull((Expression)path));
                            break;
                        }
                        default: {
                            throw new ProcessedException("\u9519\u8bef\u7684\u53c2\u6570");
                        }
                    }
                }
                if (!predicates.isEmpty()) {
                    criteriaQuery.where(predicates.toArray(new Predicate[0]));
                }
                return criteriaQuery.getRestriction();
            }
            logger.debug("filters == null");
            return criteriaBuilder.conjunction();
        };
    }

    public static <T> Specification<T> mergeSpecification(Specification<T> firstSpecification, Specification<T> ... specifications) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            List<Predicate> predicates = Stream.of(firstSpecification.toPredicate(root, criteriaQuery, criteriaBuilder)).collect(Collectors.toList());
            if (specifications != null) {
                for (Specification specification : specifications) {
                    predicates.add(specification.toPredicate(root, criteriaQuery, criteriaBuilder));
                }
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.toArray(new Predicate[0]));
            }
            return criteriaQuery.getRestriction();
        };
    }

    private static Object parseValue(Class pathClass, Object value) {
        if (pathClass == null || value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(pathClass)) {
            if (value instanceof String) {
                return value;
            }
            return value.toString();
        }
        if (pathClass.isEnum()) {
            logger.debug("path is enum");
            try {
                if (value.getClass().isAssignableFrom(pathClass)) {
                    return value;
                }
                return Enum.valueOf(pathClass, value.toString());
            }
            catch (IllegalArgumentException e) {
                logger.warn(e.getMessage());
                return null;
            }
        }
        if (Date.class.isAssignableFrom(pathClass)) {
            if (value.getClass().isAssignableFrom(pathClass)) {
                return value;
            }
            return DynamicSpecifications.date(value.toString());
        }
        if (Number.class.isAssignableFrom(pathClass)) {
            if (value.getClass().isAssignableFrom(pathClass)) {
                return value;
            }
            if (value instanceof String) {
                return NumberUtils.parseNumber((String)((String)value), (Class)pathClass);
            }
            return NumberUtils.parseNumber((String)value.toString(), (Class)pathClass);
        }
        return value;
    }

    private static Object parseValue(Path path, Object value) {
        if (path == null || value == null) {
            return null;
        }
        Class pathClass = path.getJavaType();
        return DynamicSpecifications.parseValue(pathClass, value);
    }

    private static Object[] parseValues(Class pathClass, Operator operator, Object ... values) {
        if (Operator.BETWEEN.equals(operator)) {
            if (values.length != 2 || !Comparable.class.isAssignableFrom(pathClass)) {
                return null;
            }
            Arrays.sort(values);
            if (Date.class.isAssignableFrom(pathClass)) {
                Date fromDate = values[0].getClass().isAssignableFrom(pathClass) ? (Date)values[0] : (values[0] instanceof String ? DynamicSpecifications.fromDate((String)values[0]) : DynamicSpecifications.fromDate(values[0].toString()));
                Date toDate = values[1].getClass().isAssignableFrom(pathClass) ? (Date)values[1] : (values[1] instanceof String ? DynamicSpecifications.toDate((String)values[1]) : DynamicSpecifications.toDate(values[1].toString()));
                return new Date[]{fromDate, toDate};
            }
        }
        return Arrays.stream(values).map(value -> DynamicSpecifications.parseValue(pathClass, value)).toArray(Object[]::new);
    }

    private static Object[] parseValues(Path path, Operator operator, Object ... values) {
        return DynamicSpecifications.parseValues(path.getJavaType(), operator, values);
    }

    private static Date date(String date) {
        try {
            return DateUtils.parseDateStrictly((String)date, (String[])PATTERNS);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static Date fromDate(String value) {
        if (Pattern.matches("\\d{4}-\\d{2}-\\d{2}\\s+\\d{2}:\\d{2}:\\d{2}", value)) {
            return DynamicSpecifications.date(value);
        }
        if (Pattern.matches("\\d{4}-\\d{2}-\\d{2}", value)) {
            Calendar calendar = Calendar.getInstance();
            Date date = DynamicSpecifications.date(value);
            if (date == null) {
                return null;
            }
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }
        return null;
    }

    private static Date toDate(String value) {
        if (Pattern.matches("\\d{4}-\\d{2}-\\d{2}\\s+\\d{2}:\\d{2}:\\d{2}", value)) {
            return DynamicSpecifications.date(value);
        }
        if (Pattern.matches("\\d{4}-\\d{2}-\\d{2}", value)) {
            Calendar calendar = Calendar.getInstance();
            Date date = DynamicSpecifications.date(value);
            if (date == null) {
                return null;
            }
            calendar.setTime(date);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
            return calendar.getTime();
        }
        return null;
    }
}

