/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.id;

import io.geewit.data.jpa.essential.id.TableGenerator;
import java.io.Serializable;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;

public class FormatTableGenerator
extends TableGenerator {
    public static final String FORMAT_PARAM = "format";
    protected String formatValue;

    @Override
    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        super.configure((Type)new LongType(), params, serviceRegistry);
        this.formatValue = params.getProperty(FORMAT_PARAM);
    }

    @Override
    public Serializable generate(SharedSessionContractImplementor session, Object obj) {
        Serializable generated = super.generate(session, obj);
        if (generated instanceof Number) {
            if (this.formatValue == null) {
                return String.valueOf(generated);
            }
            return String.format(this.formatValue, generated);
        }
        return generated;
    }
}

