/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.repository.support;

import io.geewit.data.jpa.essential.repository.support.CountQueryDetector;
import io.geewit.data.jpa.essential.repository.support.EntityGraphBean;
import io.geewit.data.jpa.essential.repository.support.QueryHintsUtils;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.jpa.repository.support.QueryHints;

class RepositoryQueryEntityGraphInjector
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryQueryEntityGraphInjector.class);
    private static final List<String> EXECUTE_QUERY_METHODS = Stream.of("getResultList", "getSingleResult", "scroll").collect(Collectors.toList());
    private static final String UNWRAP_METHOD = "unwrap";
    private final EntityManager entityManager;
    private final EntityGraphBean entityGraphCandidate;

    private RepositoryQueryEntityGraphInjector(EntityManager entityManager, EntityGraphBean entityGraphCandidate) {
        this.entityManager = Objects.requireNonNull(entityManager);
        this.entityGraphCandidate = Objects.requireNonNull(entityGraphCandidate);
    }

    static Query proxy(Query query, EntityManager entityManager, EntityGraphBean entityGraphCandidate) {
        ProxyFactory proxyFactory = new ProxyFactory((Object)query);
        proxyFactory.addAdvice((Advice)new RepositoryQueryEntityGraphInjector(entityManager, entityGraphCandidate));
        return (Query)proxyFactory.getProxy();
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String invokedMethodName = invocation.getMethod().getName();
        Object[] invokedMethodArguments = invocation.getArguments();
        if (UNWRAP_METHOD.equals(invocation.getMethod().getName()) && invokedMethodArguments.length == 1 && invokedMethodArguments[0] == null) {
            return invocation.getThis();
        }
        if (EXECUTE_QUERY_METHODS.contains(invokedMethodName)) {
            this.addEntityGraphToQuery((Query)invocation.getThis());
        }
        return invocation.proceed();
    }

    private void addEntityGraphToQuery(Query query) {
        if (CountQueryDetector.isCountQuery()) {
            logger.trace("CountQuery detected.");
            return;
        }
        if (!this.entityGraphCandidate.isPrimary() && QueryHintsUtils.containsEntityGraph(query.getHints())) {
            logger.trace("The query hints passed with the find method already hold an entity graph. Overriding aborted because the candidate EntityGraph is optional.");
            return;
        }
        QueryHintsUtils.removeEntityGraphs(query.getHints());
        QueryHints hints = QueryHintsUtils.buildQueryHints(this.entityManager, this.entityGraphCandidate);
        hints.forEach((arg_0, arg_1) -> ((Query)query).setHint(arg_0, arg_1));
    }
}

