/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.repository.impl;

import io.geewit.data.jpa.essential.domain.EntityGraph;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaRepository;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaSpecificationExecutor;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.transaction.annotation.Transactional;

public class EntityGraphSimpleJpaRepository<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements EntityGraphJpaRepository<T, ID>,
EntityGraphJpaSpecificationExecutor<T>,
JpaBatchExecutor<T> {
    private static final Logger logger = LoggerFactory.getLogger(EntityGraphSimpleJpaRepository.class);
    private final EntityManager entityManager;
    private static final Integer BATCH_SIZE = 500;

    public EntityGraphSimpleJpaRepository(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.entityManager = entityManager;
        logger.debug("BATCH_SIZE = {}", (Object)BATCH_SIZE);
    }

    public EntityGraphSimpleJpaRepository(Class<T> domainClass, EntityManager entityManager) {
        super(domainClass, entityManager);
        this.entityManager = entityManager;
        logger.debug("BATCH_SIZE = {}", (Object)BATCH_SIZE);
    }

    @Override
    public Optional<T> findOne(Specification<T> spec, EntityGraph entityGraph) {
        return super.findOne(spec);
    }

    @Override
    public List<T> findAll(Specification<T> spec, EntityGraph entityGraph) {
        return super.findAll(spec);
    }

    @Override
    public Page<T> findAll(Specification<T> spec, Pageable pageable, EntityGraph entityGraph) {
        return super.findAll(spec, pageable);
    }

    @Override
    public List<T> findAll(Specification<T> spec, Sort sort, EntityGraph entityGraph) {
        return super.findAll(spec, sort);
    }

    @Override
    public Optional<T> findById(ID id, EntityGraph entityGraph) {
        return super.findById(id);
    }

    @Override
    public Page<T> findAll(Pageable pageable, EntityGraph entityGraph) {
        return super.findAll(pageable);
    }

    @Override
    public List<T> findAllById(Iterable<ID> ids, EntityGraph entityGraph) {
        return super.findAllById(ids);
    }

    @Override
    public Iterable<T> findAll(Sort sort, EntityGraph entityGraph) {
        return super.findAll(sort);
    }

    @Override
    public Iterable<T> findAll(EntityGraph entityGraph) {
        return super.findAll();
    }

    @Override
    @Transactional
    public List<T> saveBatch(Iterable<T> entities) {
        ArrayList<T> result = new ArrayList<T>();
        int i = 0;
        Iterator<T> iterator = entities.iterator();
        while (iterator.hasNext()) {
            ++i;
            T entity = iterator.next();
            if (entity != null) {
                this.entityManager.persist(entity);
            }
            if (i % BATCH_SIZE == 0 || !iterator.hasNext()) {
                logger.info("Flushing the EntityManager containing {} entities ...", (Object)i);
                if (entity != null) {
                    this.entityManager.flush();
                    this.entityManager.clear();
                }
                i = 0;
            }
            if (entity == null) continue;
            result.add(entity);
        }
        logger.info("Flushing the remaining entities ...");
        return result;
    }
}

