/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.util.Streamable;
import org.springframework.util.CollectionUtils;

public class SortFactory {
    private static final Sort.Direction DEFAULT_DIRECTION = Sort.Direction.DESC;

    public static Sort create(String sortProperty, Sort.Direction direction) {
        if (sortProperty == null) {
            return Sort.unsorted();
        }
        return Sort.by((Sort.Direction)direction, (String[])new String[]{sortProperty});
    }

    public static Sort create(String sortProperty, String order) {
        if (sortProperty == null) {
            return Sort.unsorted();
        }
        Sort.Direction direction = StringUtils.isNotBlank((CharSequence)order) && Sort.Direction.DESC.name().equalsIgnoreCase(order) ? Sort.Direction.DESC : Sort.Direction.ASC;
        return Sort.by((Sort.Direction)direction, (String[])new String[]{sortProperty});
    }

    public static Sort create(Sort sort, String sortPropterty, Sort.Direction direction) {
        ArrayList<Sort.Order> orderList = new ArrayList<Sort.Order>();
        if (sort != null) {
            orderList.addAll(sort.toList());
        }
        if (sortPropterty != null) {
            orderList.add(new Sort.Order(direction != null ? direction : DEFAULT_DIRECTION, sortPropterty));
        }
        return orderList.isEmpty() ? Sort.unsorted() : Sort.by(orderList);
    }

    public static Sort create(Sort sort, String sortPropterty) {
        return SortFactory.create(sort, sortPropterty, DEFAULT_DIRECTION);
    }

    public static Sort create(Sort sort, Sort.Order ... orders) {
        ArrayList orderList = new ArrayList();
        if (sort != null) {
            orderList.addAll(sort.toList());
        }
        if (orders != null) {
            Collections.addAll(orderList, orders);
        }
        return CollectionUtils.isEmpty(orderList) ? Sort.unsorted() : Sort.by(orderList);
    }

    public static Sort create(Sort ... sorts) {
        if (ArrayUtils.isEmpty((Object[])sorts)) {
            return Sort.unsorted();
        }
        ArrayList orderList = new ArrayList();
        Arrays.stream(sorts).filter(Objects::nonNull).map(Streamable::toList).forEach(orderList::addAll);
        return Sort.by(orderList);
    }

    public static Sort ofDefaultSort(Sort sort, Sort defaultSort) {
        if (sort == null) {
            sort = defaultSort;
        } else if (sort.stream().noneMatch(order -> defaultSort.stream().anyMatch(defaultOrder -> defaultOrder.getProperty().equals(order.getProperty())))) {
            sort = defaultSort.and(sort);
        }
        return sort;
    }
}

