/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.utils;

import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.util.Assert;

public class TupleQueryUtils {
    public static long executeCountQuery(TypedQuery<Long> query) {
        Assert.notNull(query, (String)"TypedQuery must not be null!");
        List totals = query.getResultList();
        long total = 0L;
        for (Long element : totals) {
            total += element == null ? 0L : element;
        }
        return total;
    }

    public static <T> TypedQuery<Long> getCountQuery(EntityManager entityManager, Root<T> root, CriteriaQuery<Long> criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Assert.notNull((Object)entityManager, (String)"entityManager must not be null!");
        Assert.notNull(criteriaQuery, (String)"criteriaQuery must not be null!");
        Assert.notNull((Object)criteriaBuilder, (String)"criteriaBuilder must not be null!");
        if (criteriaQuery.isDistinct()) {
            criteriaQuery.distinct(false);
            criteriaQuery.select((Selection)criteriaBuilder.countDistinct(root));
        } else {
            criteriaQuery.select((Selection)criteriaBuilder.count(root));
        }
        criteriaQuery.orderBy(Collections.emptyList());
        TypedQuery typedQuery = entityManager.createQuery(criteriaQuery);
        return typedQuery;
    }
}

