/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.domain;

import io.geewit.data.jpa.essential.domain.EntityGraph;
import io.geewit.data.jpa.essential.domain.NamedEntityGraph;
import java.util.List;
import org.springframework.data.jpa.repository.EntityGraph;

public final class EntityGraphs {
    private static final EntityGraph EMPTY = new EmptyEntityGraph();

    private EntityGraphs() {
    }

    public static EntityGraph named(String name) {
        return new NamedEntityGraph(name);
    }

    public static EntityGraph empty() {
        return EMPTY;
    }

    public static boolean isEmpty(EntityGraph entityGraph) {
        return entityGraph == null || entityGraph.getEntityGraphAttributePaths() == null && entityGraph.getEntityGraphName() == null && entityGraph.getEntityGraphType() == null;
    }

    private static final class EmptyEntityGraph
    implements EntityGraph {
        private EmptyEntityGraph() {
        }

        @Override
        public EntityGraph.EntityGraphType getEntityGraphType() {
            return null;
        }

        @Override
        public String getEntityGraphName() {
            return null;
        }

        @Override
        public List<String> getEntityGraphAttributePaths() {
            return null;
        }

        @Override
        public boolean isOptional() {
            return false;
        }
    }
}

