/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.domain;

import io.geewit.data.jpa.essential.domain.AbstractEntityGraph;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.springframework.data.jpa.repository.EntityGraph;

public class DynamicEntityGraph
extends AbstractEntityGraph {
    private final List<String> attributePaths;

    public DynamicEntityGraph(List<String> attributePaths) {
        this.attributePaths = Collections.unmodifiableList(attributePaths);
    }

    public DynamicEntityGraph(EntityGraph.EntityGraphType type, List<String> attributePaths) {
        super(type);
        this.attributePaths = Collections.unmodifiableList(attributePaths);
    }

    @Override
    public List<String> getEntityGraphAttributePaths() {
        return this.attributePaths;
    }

    @Override
    public final String getEntityGraphName() {
        return null;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", DynamicEntityGraph.class.getSimpleName() + "[", "]").add("attributePaths=" + this.attributePaths).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicEntityGraph that = (DynamicEntityGraph)o;
        return this.attributePaths.equals(that.attributePaths) && this.getEntityGraphType() == that.getEntityGraphType() && this.isOptional() == that.isOptional();
    }

    public int hashCode() {
        return Objects.hash(this.attributePaths, this.getEntityGraphType(), this.isOptional());
    }
}

