/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.repository.impl;

import io.geewit.data.jpa.essential.repository.JpaBatchRepository;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;

public class SimpleJpaBatchRepository<T, ID>
extends SimpleJpaRepository<T, ID>
implements JpaBatchRepository<T, ID> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleJpaBatchRepository.class);
    private final EntityManager entityManager;

    public SimpleJpaBatchRepository(JpaEntityInformation<T, ID> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.entityManager = entityManager;
    }

    @Override
    public List<T> saveBatch(Iterable<T> entities) {
        ArrayList<T> result = new ArrayList<T>();
        EntityTransaction entityTransaction = this.entityManager.getTransaction();
        try {
            entityTransaction.begin();
            int i = 0;
            Session session = (Session)this.entityManager.unwrap(Session.class);
            int batchSize = session.getJdbcBatchSize();
            for (T entity : entities) {
                if (i > 0 && i % batchSize == 0) {
                    logger.info("Flushing the EntityManager containing {} entities ...", (Object)session.getJdbcBatchSize());
                    entityTransaction.commit();
                    entityTransaction.begin();
                    this.entityManager.clear();
                }
                this.entityManager.persist(entity);
                result.add(entity);
                ++i;
            }
            logger.info("Flushing the remaining entities ...");
            entityTransaction.commit();
        }
        catch (RuntimeException e) {
            if (entityTransaction.isActive()) {
                entityTransaction.rollback();
            }
            throw e;
        }
        finally {
            this.entityManager.close();
        }
        return result;
    }
}

