/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.utils;

import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.util.Assert;

public class TupleQueryUtils {
    public static long executeCountQuery(TypedQuery<Long> query) {
        Assert.notNull(query, (String)"TypedQuery must not be null!");
        List totals = query.getResultList();
        long total = 0L;
        for (Long element : totals) {
            total += element == null ? 0L : element;
        }
        return total;
    }

    public static <T> TypedQuery<Long> getCountQuery(EntityManager entityManager, Class<T> domainClass, CriteriaQuery<Long> criteriaQuery, CriteriaBuilder criteriaBuilder, Predicate predicate) {
        Assert.notNull((Object)entityManager, (String)"entityManager must not be null!");
        Root root = criteriaQuery.from(domainClass);
        if (criteriaQuery.isDistinct()) {
            criteriaQuery.select((Selection)criteriaBuilder.countDistinct((Expression)root));
        } else {
            criteriaQuery.select((Selection)criteriaBuilder.count((Expression)root));
        }
        criteriaQuery.where((Expression)predicate);
        criteriaQuery.orderBy(Collections.emptyList());
        TypedQuery typedQuery = entityManager.createQuery(criteriaQuery);
        return typedQuery;
    }
}

