/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.search;

import io.geewit.data.jpa.essential.search.Operator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SearchFilter {
    private String fieldName;
    private Operator operator;
    private Object[] values;

    private SearchFilter(String fieldName, Operator operator) {
        this.fieldName = fieldName;
        this.operator = operator;
    }

    SearchFilter(String fieldName, Operator operator, Object value) {
        this.fieldName = fieldName;
        this.operator = operator;
        this.values = new Object[]{value};
    }

    SearchFilter(String fieldName, Operator operator, Object[] values) {
        this.fieldName = fieldName;
        this.operator = operator;
        this.values = values;
    }

    public static SearchFilter build(String fieldName, Operator operator) {
        return new SearchFilter(fieldName, operator);
    }

    public static SearchFilter build(String fieldName, Operator operator, Object value) {
        return new SearchFilter(fieldName, operator, value);
    }

    public static SearchFilter build(String fieldName, Operator operator, Object[] values) {
        return new SearchFilter(fieldName, operator, values);
    }

    public static Collection<SearchFilter> parse(Map<String, Object> searchParams) {
        HashSet<SearchFilter> filters = new HashSet<SearchFilter>();
        for (Map.Entry<String, Object> entry : searchParams.entrySet()) {
            SearchFilter filter;
            String key = entry.getKey();
            Object value = entry.getValue();
            String[] names = StringUtils.split((String)key, (String)"_");
            if (names.length != 2) continue;
            String fieldName = names[1];
            Operator operator = Operator.valueOf(names[0].toUpperCase());
            if (Operator.BETWEEN.equals(operator)) {
                Object[] fieldArray = StringUtils.split((String)value.toString(), (String)",", (int)2);
                filter = new SearchFilter(fieldName, operator, fieldArray);
            } else {
                filter = new SearchFilter(fieldName, operator, value.toString());
            }
            filters.add(filter);
        }
        return filters;
    }

    public static void addFilter(Collection<SearchFilter> filters, SearchFilter filter) {
        boolean notExist = filters.stream().noneMatch(existFilter -> existFilter.fieldName.equals(filter.fieldName));
        if (notExist) {
            filters.add(filter);
        }
    }

    public static boolean exists(Collection<SearchFilter> filters, String fieldName) {
        return filters.stream().anyMatch(existFilter -> existFilter.fieldName.equals(fieldName));
    }

    public String fieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Operator operator() {
        return this.operator;
    }

    public Object[] values() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchFilter that = (SearchFilter)o;
        return Objects.equals(this.fieldName, that.fieldName) && this.operator == that.operator && Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        int result = Objects.hash(this.fieldName, this.operator);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public String toString() {
        return "SearchFilter{fieldName='" + this.fieldName + '\'' + ", operator=" + this.operator + ", values=" + Arrays.toString(this.values) + '}';
    }
}

