/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.util.Streamable;
import org.springframework.util.CollectionUtils;

public class SortFactory {
    private static final Sort.Direction defaultDirection = Sort.Direction.DESC;

    public static Sort create(String sortProperty, Sort.Direction direction) {
        if (sortProperty == null) {
            return null;
        }
        return Sort.by((Sort.Direction)direction, (String[])new String[]{sortProperty});
    }

    public static Sort create(String sortProperty, String order) {
        if (sortProperty == null) {
            return null;
        }
        Sort.Direction direction = StringUtils.isNotBlank((CharSequence)order) && Sort.Direction.DESC.name().equalsIgnoreCase(order) ? Sort.Direction.DESC : Sort.Direction.ASC;
        return Sort.by((Sort.Direction)direction, (String[])new String[]{sortProperty});
    }

    public static Sort create(Sort sort, String sortPropterty, Sort.Direction direction) {
        ArrayList<Sort.Order> orderList = sort != null ? sort.toList() : new ArrayList<Sort.Order>();
        if (sortPropterty != null) {
            orderList.add(new Sort.Order(direction != null ? direction : defaultDirection, sortPropterty));
        }
        return orderList.isEmpty() ? null : Sort.by(orderList);
    }

    public static Sort create(Sort sort, String sortPropterty) {
        return SortFactory.create(sort, sortPropterty, defaultDirection);
    }

    public static Sort create(Sort sort, Sort.Order ... orders) {
        ArrayList orderList = sort != null ? sort.toList() : new ArrayList();
        if (orders != null) {
            Collections.addAll(orderList, orders);
        }
        return CollectionUtils.isEmpty(orderList) ? null : Sort.by(orderList);
    }

    public static Sort create(Sort ... sorts) {
        if (ArrayUtils.isEmpty((Object[])sorts)) {
            return null;
        }
        ArrayList orderList = new ArrayList();
        Arrays.stream(sorts).filter(Objects::nonNull).map(Streamable::toList).forEach(orderList::addAll);
        return Sort.by(orderList);
    }
}

