/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.id;

import io.geewit.data.jpa.essential.id.TableGenerator;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class CalendarFormatTableGenerator
extends TableGenerator {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)CalendarFormatTableGenerator.class.getName());
    public static final String UPDATE_DATE_PARAM = "update_date";
    public static final String NUMBER_FORMAT_PARAM = "format";
    public static final String PREFIX_PARAM = "prefix";
    private String refreshQuery;
    private String formatValue;
    private String prefixValue;
    private String updateDateColumnName;

    @Override
    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        super.configure((Type)new LongType(), params, serviceRegistry);
        this.formatValue = params.getProperty(NUMBER_FORMAT_PARAM);
        this.prefixValue = params.getProperty(PREFIX_PARAM);
        this.updateDateColumnName = params.getProperty(UPDATE_DATE_PARAM);
    }

    @Override
    public Serializable generate(final SharedSessionContractImplementor session, Object obj) {
        LOG.log(Logger.Level.DEBUG, (Object)("segmentValue = " + this.segmentValue));
        final SqlStatementLogger statementLogger = ((JdbcServices)session.getFactory().getServiceRegistry().getService(JdbcServices.class)).getSqlStatementLogger();
        final SessionEventListenerManager statsCollector = session.getEventListenerManager();
        final Calendar now = Calendar.getInstance(Locale.CHINA);
        final Date nowDate = new Date(now.getTimeInMillis());
        Serializable generated = this.optimizer.generate(new AccessCallback(){

            public IntegralDataTypeHolder getNextValue() {
                return (IntegralDataTypeHolder)session.getTransactionCoordinator().createIsolationDelegate().delegateWork((WorkExecutorVisitable)new AbstractReturningWork<IntegralDataTypeHolder>(){

                    public IntegralDataTypeHolder execute(Connection connection) throws SQLException {
                        int rows;
                        IntegralDataTypeHolder value = CalendarFormatTableGenerator.this.makeValue();
                        do {
                            try (PreparedStatement selectPS = CalendarFormatTableGenerator.this.prepareStatement(connection, CalendarFormatTableGenerator.this.selectQuery, statementLogger, statsCollector);){
                                IntegralDataTypeHolder updateValue2;
                                Throwable throwable;
                                selectPS.setString(1, CalendarFormatTableGenerator.this.segmentValue);
                                ResultSet selectRS = CalendarFormatTableGenerator.this.executeQuery(selectPS, statsCollector);
                                boolean needInitialize = false;
                                boolean needRefresh = false;
                                if (!selectRS.next()) {
                                    needInitialize = true;
                                } else if (selectRS.wasNull()) {
                                    needInitialize = true;
                                }
                                if (needInitialize) {
                                    value.initialize((long)CalendarFormatTableGenerator.this.initialValue);
                                    throwable = null;
                                    try (PreparedStatement insertPS = CalendarFormatTableGenerator.this.prepareStatement(connection, CalendarFormatTableGenerator.this.insertQuery, statementLogger, statsCollector);){
                                        insertPS.setString(1, CalendarFormatTableGenerator.this.segmentValue);
                                        value.bind(insertPS, 2);
                                        insertPS.setDate(3, nowDate);
                                        CalendarFormatTableGenerator.this.executeUpdate(insertPS, statsCollector);
                                    }
                                    catch (Throwable throwable2) {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                } else {
                                    Date updateDate = selectRS.getDate(2);
                                    if (updateDate == null) {
                                        value.initialize((long)CalendarFormatTableGenerator.this.initialValue);
                                        needRefresh = true;
                                    } else if (!DateUtils.isSameDay((Calendar)DateUtils.toCalendar((java.util.Date)updateDate), (Calendar)now)) {
                                        value.initialize((long)CalendarFormatTableGenerator.this.initialValue);
                                        needRefresh = true;
                                    } else {
                                        value.initialize(selectRS.getLong(1));
                                    }
                                }
                                selectRS.close();
                                if (needRefresh) {
                                    try {
                                        throwable = null;
                                        try (PreparedStatement refreshPS = CalendarFormatTableGenerator.this.prepareStatement(connection, CalendarFormatTableGenerator.this.refreshQuery, statementLogger, statsCollector);){
                                            updateValue2 = value.copy();
                                            if (CalendarFormatTableGenerator.this.optimizer.applyIncrementSizeToSourceValues()) {
                                                updateValue2.add((long)CalendarFormatTableGenerator.this.incrementSize);
                                            } else {
                                                updateValue2.increment();
                                            }
                                            updateValue2.bind(refreshPS, 1);
                                            refreshPS.setDate(2, nowDate);
                                            refreshPS.setString(3, CalendarFormatTableGenerator.this.segmentValue);
                                            rows = CalendarFormatTableGenerator.this.executeUpdate(refreshPS, statsCollector);
                                            continue;
                                        }
                                        catch (Throwable updateValue2) {
                                            throwable = updateValue2;
                                            throw updateValue2;
                                        }
                                    }
                                    catch (SQLException e) {
                                        LOG.unableToUpdateQueryHiValue(CalendarFormatTableGenerator.this.renderedTableName, e);
                                        throw e;
                                    }
                                }
                                try {
                                    throwable = null;
                                    try (PreparedStatement updatePS = CalendarFormatTableGenerator.this.prepareStatement(connection, CalendarFormatTableGenerator.this.updateQuery, statementLogger, statsCollector);){
                                        updateValue2 = value.copy();
                                        if (CalendarFormatTableGenerator.this.optimizer.applyIncrementSizeToSourceValues()) {
                                            updateValue2.add((long)CalendarFormatTableGenerator.this.incrementSize);
                                        } else {
                                            updateValue2.increment();
                                        }
                                        updateValue2.bind(updatePS, 1);
                                        updatePS.setDate(2, nowDate);
                                        value.bind(updatePS, 3);
                                        updatePS.setString(4, CalendarFormatTableGenerator.this.segmentValue);
                                        rows = CalendarFormatTableGenerator.this.executeUpdate(updatePS, statsCollector);
                                    }
                                    catch (Throwable throwable3) {
                                        throwable = throwable3;
                                        throw throwable3;
                                    }
                                }
                                catch (SQLException e) {
                                    LOG.unableToUpdateQueryHiValue(CalendarFormatTableGenerator.this.renderedTableName, e);
                                    throw e;
                                }
                            }
                            catch (SQLException e) {
                                LOG.unableToReadOrInitHiValue(e);
                                throw e;
                            }
                        } while (rows == 0);
                        ++CalendarFormatTableGenerator.this.accessCount;
                        return value;
                    }
                }, true);
            }

            public String getTenantIdentifier() {
                return session.getTenantIdentifier();
            }
        });
        if (generated instanceof Number) {
            StringBuilder builder = StringUtils.isNotBlank((CharSequence)this.prefixValue) ? new StringBuilder(this.prefixValue) : new StringBuilder();
            if (this.formatValue == null) {
                builder.append(generated);
            } else {
                builder.append(String.format("%2$tY%2$tm%2$td" + this.formatValue, generated, now));
            }
            return builder.toString();
        }
        return generated;
    }

    @Override
    public void registerExportables(Database database) {
        super.registerExportables(database);
        this.refreshQuery = this.buildRefreshQuery();
    }

    @Override
    protected String buildSelectQuery(Dialect dialect) {
        String alias = "tbl";
        String query = "select " + StringHelper.qualify((String)"tbl", (String)this.valueColumnName) + ", " + StringHelper.qualify((String)"tbl", (String)this.updateDateColumnName) + " from " + this.renderedTableName + ' ' + "tbl" + " where " + StringHelper.qualify((String)"tbl", (String)this.segmentColumnName) + "=?";
        LockOptions lockOptions = new LockOptions(LockMode.PESSIMISTIC_WRITE);
        lockOptions.setAliasSpecificLockMode("tbl", LockMode.PESSIMISTIC_WRITE);
        Map<String, String[]> updateTargetColumnsMap = Collections.singletonMap("tbl", new String[]{this.valueColumnName});
        String sql = dialect.applyLocksToSql(query, lockOptions, updateTargetColumnsMap);
        LOG.debug((Object)("selectQuery = " + sql));
        return sql;
    }

    @Override
    protected String buildUpdateQuery() {
        return "update " + this.renderedTableName + " set " + this.valueColumnName + "=?, " + this.updateDateColumnName + "=? where " + this.valueColumnName + "=? and " + this.segmentColumnName + "=?";
    }

    private String buildRefreshQuery() {
        return "update " + this.renderedTableName + " set " + this.valueColumnName + "=?, " + this.updateDateColumnName + "=? where " + this.segmentColumnName + "=?";
    }

    @Override
    protected String buildInsertQuery() {
        return "insert into " + this.renderedTableName + " (" + this.segmentColumnName + ", " + this.valueColumnName + ", " + this.updateDateColumnName + ")  values (?, ?, ?)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepareStatement(Connection connection, String sql, SqlStatementLogger statementLogger, SessionEventListenerManager statsCollector) throws SQLException {
        statementLogger.logStatement(sql, FormatStyle.BASIC.getFormatter());
        try {
            statsCollector.jdbcPrepareStatementStart();
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            return preparedStatement;
        }
        finally {
            statsCollector.jdbcPrepareStatementEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdate(PreparedStatement ps, SessionEventListenerManager statsCollector) throws SQLException {
        try {
            statsCollector.jdbcExecuteStatementStart();
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            statsCollector.jdbcExecuteStatementEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executeQuery(PreparedStatement ps, SessionEventListenerManager statsCollector) throws SQLException {
        try {
            statsCollector.jdbcExecuteStatementStart();
            ResultSet resultSet = ps.executeQuery();
            return resultSet;
        }
        finally {
            statsCollector.jdbcExecuteStatementEnd();
        }
    }

    private IntegralDataTypeHolder makeValue() {
        return IdentifierGeneratorHelper.getIntegralDataTypeHolder((Class)this.identifierType.getReturnedClass());
    }
}

