/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.web.servlet;

import com.google.common.collect.Maps;
import io.geewit.core.utils.lang.StringUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.WebRequest;

public class Servlets {
    private static final Logger logger = LoggerFactory.getLogger(Servlets.class);
    public static final long ONE_YEAR_SECONDS = 31536000L;

    public static void setExpiresHeader(HttpServletResponse response, long expiresSeconds) {
        response.setDateHeader("Expires", System.currentTimeMillis() + expiresSeconds * 1000L);
        response.setHeader("Cache-Control", "max-age=" + expiresSeconds);
    }

    public static void setNoCacheHeader(HttpServletResponse response) {
        response.setDateHeader("Expires", 1L);
        response.addHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache, no-store, max-age=0");
    }

    public static Map<String, Object> getParametersStartingWith(WebRequest request, String prefix) {
        logger.debug("prefix = " + prefix);
        Validate.notNull((Object)request, (String)"Request must not be null", (Object[])new Object[0]);
        Iterator paramNames = request.getParameterNames();
        TreeMap params = Maps.newTreeMap();
        if (prefix == null) {
            prefix = "";
        }
        while (paramNames.hasNext()) {
            String paramName = (String)paramNames.next();
            logger.debug("paramName = " + paramName);
            if (!"".equals(prefix) && !paramName.startsWith(prefix)) continue;
            String unprefixed = paramName.substring(prefix.length());
            String[] values = request.getParameterValues(paramName);
            if (values != null && values.length == 1) {
                Boolean boolValue = StringUtils.convert((String)values[0]);
                if (boolValue == null) {
                    params.put(unprefixed, values[0]);
                    continue;
                }
                if (boolValue.booleanValue()) {
                    params.put(unprefixed, true);
                    continue;
                }
                params.put(unprefixed, false);
                continue;
            }
            params.put(unprefixed, values);
        }
        return params;
    }

    public static String encodeParameterStringWithPrefix(Map<String, Object> params, String prefix) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        if (prefix == null) {
            prefix = "";
        }
        StringBuilder queryStringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, Object>> it = params.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            queryStringBuilder.append(prefix).append(entry.getKey()).append('=').append(entry.getValue());
            if (!it.hasNext()) continue;
            queryStringBuilder.append('&');
        }
        return queryStringBuilder.toString();
    }
}

