/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.id;

import io.geewit.snowflake.SnowFlake;
import io.geewit.snowflake.utils.NetUtils;
import java.io.Serializable;
import java.net.SocketException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.RandomUtils;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeGenerator
implements IdentifierGenerator,
Configurable {
    private static final Logger logger = LoggerFactory.getLogger(SnowflakeGenerator.class);
    private static final String WORKER_ID_SETTING_KEY = "geewit.snowflake.worker_id";
    private static final String APP_ID_SETTING_KEY = "geewit.snowflake.app_id";
    private static long WORKER_ID;
    private static long APP_ID;

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        if (WORKER_ID == 0L) {
            Map settings = ((ConfigurationService)serviceRegistry.getService(ConfigurationService.class)).getSettings();
            Object objWorkerId = settings.get(WORKER_ID_SETTING_KEY);
            if (objWorkerId != null) {
                String workerId = objWorkerId.toString();
                logger.debug("settings.workerId = " + workerId);
                try {
                    WORKER_ID = Long.parseLong(workerId);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                Object objAppId = settings.get(APP_ID_SETTING_KEY);
                if (objAppId != null) {
                    String appId = objAppId.toString();
                    logger.debug("settings.appId = " + appId);
                    try {
                        APP_ID = Long.parseLong(appId);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (APP_ID == 0L) {
                    APP_ID = RandomUtils.nextLong((long)1L, (long)10000L);
                }
                try {
                    long mac = NetUtils.getLongMac();
                    logger.info("mac: " + mac);
                    WORKER_ID = APP_ID ^ mac;
                }
                catch (SocketException e) {
                    logger.warn(e.getMessage());
                }
            }
            if (WORKER_ID == 0L) {
                WORKER_ID = RandomUtils.nextLong((long)1L, (long)10000L);
            }
        }
    }

    public Serializable generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        long id = SnowFlake.ofCached((long)WORKER_ID).getUID();
        logger.debug("generate.id = " + id);
        return Long.valueOf(id);
    }
}

