/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.domain;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.util.CollectionUtils;

public class SortFactory {
    private static final Sort.Direction defaultDirection = Sort.Direction.DESC;

    public static Sort create(String sortProperty, Sort.Direction direction) {
        if (sortProperty == null) {
            return null;
        }
        return new Sort(direction, new String[]{sortProperty});
    }

    public static Sort create(String sortProperty, String order) {
        if (sortProperty == null) {
            return null;
        }
        Sort.Direction direction = StringUtils.isNotBlank((CharSequence)order) && Sort.Direction.DESC.name().equalsIgnoreCase(order) ? Sort.Direction.DESC : Sort.Direction.ASC;
        return new Sort(direction, new String[]{sortProperty});
    }

    public static Sort create(Sort sort, String sortPropterty, Sort.Direction direction) {
        ArrayList orderList = sort != null ? Lists.newArrayList((Iterator)sort.iterator()) : Lists.newArrayList();
        if (sortPropterty != null) {
            orderList.add(new Sort.Order(direction != null ? direction : defaultDirection, sortPropterty));
        }
        return orderList.isEmpty() ? null : Sort.by((List)orderList);
    }

    public static Sort create(Sort sort, String sortPropterty) {
        return SortFactory.create(sort, sortPropterty, defaultDirection);
    }

    public static Sort create(Sort sort, Sort.Order ... orders) {
        ArrayList orderList = sort != null ? Lists.newArrayList((Iterator)sort.iterator()) : Lists.newArrayList();
        if (orders != null) {
            Collections.addAll(orderList, orders);
        }
        return CollectionUtils.isEmpty((Collection)orderList) ? null : Sort.by((List)orderList);
    }

    public static Sort create(Sort ... sorts) {
        if (ArrayUtils.isEmpty((Object[])sorts)) {
            return null;
        }
        ArrayList orderList = Lists.newArrayList();
        for (Sort sort : sorts) {
            if (sort == null) continue;
            orderList.addAll(Lists.newArrayList((Iterator)sort.iterator()));
        }
        return Sort.by((List)orderList);
    }
}

