/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.search;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.geewit.core.exception.CustomizedException;
import io.geewit.data.jpa.essential.search.BetweenType;
import io.geewit.data.jpa.essential.search.Operator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SearchFilter {
    private String fieldName;
    private Operator operator;
    private Object[] values;

    private SearchFilter(String fieldName, Operator operator) {
        this.fieldName = fieldName;
        this.operator = operator;
    }

    private SearchFilter(String fieldName, Operator operator, Object value) {
        this.fieldName = fieldName;
        this.operator = operator;
        this.values = new Object[]{value};
    }

    private SearchFilter(String fieldName, Operator operator, Object[] values) {
        this.fieldName = fieldName;
        this.operator = operator;
        this.values = values;
    }

    public static SearchFilter build(String fieldName, Operator operator) {
        return new SearchFilter(fieldName, operator);
    }

    public static SearchFilter build(String fieldName, Operator operator, Object value) {
        return new SearchFilter(fieldName, operator, value);
    }

    public static SearchFilter build(String fieldName, Operator operator, Object[] values) {
        return new SearchFilter(fieldName, operator, values);
    }

    public static Collection<SearchFilter> parse(Map<String, Object> searchParams) {
        SearchFilter filter;
        HashSet filters = Sets.newHashSet();
        Map betweens = null;
        for (Map.Entry<String, Object> entry : searchParams.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String[] names = StringUtils.split((String)key, (String)"_");
            if (names.length != 2 && names.length != 3) continue;
            String fieldName = names[1];
            Operator operator = Operator.valueOf(names[0].toUpperCase());
            if (Operator.BETWEEN.equals((Object)operator)) {
                if (names.length != 3) continue;
                if (betweens == null) {
                    betweens = Maps.newHashMap();
                }
                BetweenType betweenType = BetweenType.valueOf(names[2].toUpperCase());
                Object[] fieldArray = (Object[])betweens.get(fieldName);
                if (fieldArray == null) {
                    fieldArray = new Object[]{null, null};
                }
                switch (betweenType) {
                    case LOW: {
                        fieldArray[0] = value;
                        break;
                    }
                    case HIGH: {
                        fieldArray[1] = value;
                        break;
                    }
                    default: {
                        throw new CustomizedException("\u9519\u8bef\u7684\u53c2\u6570");
                    }
                }
                betweens.put(fieldName, fieldArray);
                continue;
            }
            filter = new SearchFilter(fieldName, operator, value);
            filters.add(filter);
        }
        if (betweens != null && !betweens.isEmpty()) {
            for (Map.Entry<String, Object> entry : betweens.entrySet()) {
                filter = new SearchFilter(entry.getKey(), Operator.BETWEEN, (Object[])entry.getValue());
                filters.add(filter);
            }
        }
        return filters;
    }

    public static void addFilter(Collection<SearchFilter> filters, SearchFilter filter) {
        boolean notExist = true;
        for (SearchFilter existFilter : filters) {
            if (!existFilter.fieldName.equals(filter.fieldName)) continue;
            notExist = false;
            break;
        }
        if (notExist) {
            filters.add(filter);
        }
    }

    public static boolean exists(Collection<SearchFilter> filters, String fieldName) {
        for (SearchFilter existFilter : filters) {
            if (!existFilter.fieldName.equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Operator operator() {
        return this.operator;
    }

    public Object[] values() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchFilter that = (SearchFilter)o;
        return Objects.equal((Object)this.fieldName, (Object)that.fieldName) && Objects.equal((Object)((Object)this.operator), (Object)((Object)that.operator));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fieldName, this.operator});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fieldName", (Object)this.fieldName).add("values", (Object)this.values).add("operator", (Object)this.operator).toString();
    }
}

