/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.domain;

import io.geewit.data.jpa.essential.domain.SortFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageableFactory {
    private static final int defaultSize = 20;
    private static final String defaultSort = null;

    public static Pageable create(Integer page, Integer size) {
        return PageRequest.of((int)page, (int)(null != size && size > 0 ? size : 20));
    }

    public static Pageable create(Integer page, Integer size, int defaultSize) {
        return PageRequest.of((int)page, (int)(null != size && size > 0 ? size : defaultSize));
    }

    public static Pageable create(Integer page, Integer size, Sort sort) {
        return PageRequest.of((int)page, (int)(null != size && size > 0 ? size : 20), (Sort)sort);
    }

    public static Pageable create(Integer page, Integer size, int defaultSize, Sort sort) {
        return PageRequest.of((int)page, (int)(null != size && size > 0 ? size : defaultSize), (Sort)sort);
    }

    public static Pageable create(Integer page, Integer size, String sort, String order) {
        return PageableFactory.create(page, size, 20, sort, defaultSort, order);
    }

    public static Pageable create(Integer page, Integer size, int defaultSize, String sort, String order) {
        return PageableFactory.create(page, size, defaultSize, sort, defaultSort, order);
    }

    public static Pageable create(Integer page, Integer size, String sort, String defaultSort, String order) {
        return PageableFactory.create(page, size, 20, sort, defaultSort, order);
    }

    public static Pageable create(Integer page, Integer size, int defaultSize, String sortProperty, String defaultSort, String order) {
        Sort sort = SortFactory.create(sortProperty == null ? defaultSort : sortProperty, order);
        return PageRequest.of((int)page, (int)(null != size && size > 0 ? size : defaultSize), (Sort)sort);
    }

    public static Pageable create(Pageable pageable, String sortPropterty, Sort.Direction direction) {
        Sort sort = SortFactory.create(pageable.getSort(), sortPropterty, direction);
        return PageableFactory.create((Integer)pageable.getPageNumber(), (Integer)pageable.getPageSize(), sort);
    }

    public static Pageable create(Pageable pageable, String sortPropterty) {
        Sort sort = SortFactory.create(pageable.getSort(), sortPropterty);
        return PageableFactory.create((Integer)pageable.getPageNumber(), (Integer)pageable.getPageSize(), sort);
    }

    public static Pageable create(Pageable pageable, Sort sort) {
        sort = SortFactory.create(pageable.getSort(), sort);
        return PageableFactory.create((Integer)pageable.getPageNumber(), (Integer)pageable.getPageSize(), sort);
    }

    public static Pageable create(Pageable pageable, Sort.Order ... orders) {
        Sort sort = SortFactory.create(pageable.getSort(), orders);
        return PageableFactory.create((Integer)pageable.getPageNumber(), (Integer)pageable.getPageSize(), sort);
    }
}

