/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.essential.search;

import com.google.common.collect.Lists;
import io.geewit.core.exception.CustomizedException;
import io.geewit.data.jpa.essential.search.BetweenType;
import io.geewit.data.jpa.essential.search.SearchFilter;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.regex.Pattern;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.NumberUtils;

public class DynamicSpecifications {
    private static final Logger logger = LoggerFactory.getLogger(DynamicSpecifications.class);
    private static final String[] PATTERNS = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "HH:mm:ss"};

    public static <T> Specification<T> bySearchFilter(Collection<SearchFilter> filters) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            if (filters != null && !filters.isEmpty()) {
                logger.debug("filters != null");
                ArrayList predicates = Lists.newArrayList();
                block16: for (SearchFilter filter : filters) {
                    Path path;
                    if (logger.isDebugEnabled()) {
                        logger.debug("filter.fieldName = " + filter.fieldName());
                        logger.debug("filter.values = " + StringUtils.join((Object[])filter.values(), (String)","));
                        logger.debug("filter.operator = " + (Object)((Object)filter.operator()));
                        logger.debug("root.model = " + root.getModel().getName());
                    }
                    if (StringUtils.contains((CharSequence)filter.fieldName(), (int)36)) {
                        String[] fields = StringUtils.split((String)filter.fieldName(), (char)'$');
                        path = root.get(fields[0]);
                        for (int i = 1; i < fields.length && (path = path.get(fields[i])) != null; ++i) {
                        }
                    } else {
                        path = root.get(filter.fieldName());
                    }
                    if (path == null) break;
                    switch (filter.operator()) {
                        case EQ: {
                            Object value;
                            logger.debug("case EQ");
                            if (filter.values() == null || filter.values().length <= 0 || (value = DynamicSpecifications.parseValue(path, filter.values()[0], false, null)) == null) continue block16;
                            predicates.add(criteriaBuilder.equal((Expression)path, value));
                            break;
                        }
                        case NE: {
                            Object value;
                            logger.debug("case NE");
                            if (filter.values() == null || filter.values().length <= 0 || (value = DynamicSpecifications.parseValue(path, filter.values()[0], false, null)) == null) continue block16;
                            predicates.add(criteriaBuilder.notEqual((Expression)path, value));
                            break;
                        }
                        case LIKE: {
                            logger.debug("case LIKE");
                            if (filter.values() == null || filter.values().length <= 0 || !StringUtils.isNotEmpty((CharSequence)filter.values()[0].toString())) continue block16;
                            predicates.add(criteriaBuilder.like((Expression)path, "%" + filter.values()[0].toString() + "%"));
                            break;
                        }
                        case LLIKE: {
                            logger.debug("case LLIKE");
                            if (filter.values() == null || filter.values().length <= 0 || !StringUtils.isNotEmpty((CharSequence)filter.values()[0].toString())) continue block16;
                            predicates.add(criteriaBuilder.like((Expression)path, "%" + filter.values()[0].toString()));
                            break;
                        }
                        case RLIKE: {
                            logger.debug("case RLIKE");
                            if (filter.values() == null || filter.values().length <= 0 || !StringUtils.isNotEmpty((CharSequence)filter.values()[0].toString())) continue block16;
                            predicates.add(criteriaBuilder.like((Expression)path, filter.values()[0].toString() + "%"));
                            break;
                        }
                        case GT: {
                            Object value;
                            logger.debug("case GT");
                            if (filter.values() == null || filter.values().length <= 0 || !((value = DynamicSpecifications.parseValue(path, filter.values()[0], true, null)) instanceof Comparable) || !StringUtils.isNotEmpty((CharSequence)filter.values()[0].toString())) continue block16;
                            predicates.add(criteriaBuilder.greaterThan((Expression)path, (Comparable)value));
                            break;
                        }
                        case GTE: {
                            Object value;
                            logger.debug("case GTE");
                            if (filter.values() == null || filter.values().length <= 0 || !((value = DynamicSpecifications.parseValue(path, filter.values()[0], true, null)) instanceof Comparable) || !StringUtils.isNotEmpty((CharSequence)filter.values()[0].toString())) continue block16;
                            predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)path, (Comparable)value));
                            break;
                        }
                        case LT: {
                            Object value;
                            logger.debug("case LT");
                            if (filter.values() == null || filter.values().length <= 0 || !((value = DynamicSpecifications.parseValue(path, filter.values()[0], true, null)) instanceof Comparable) || !StringUtils.isNotEmpty((CharSequence)filter.values()[0].toString())) continue block16;
                            predicates.add(criteriaBuilder.lessThan((Expression)path, (Comparable)value));
                            break;
                        }
                        case LTE: {
                            Object value;
                            logger.debug("case LTE");
                            if (filter.values() == null || filter.values().length <= 0 || !((value = DynamicSpecifications.parseValue(path, filter.values()[0], true, null)) instanceof Comparable) || !StringUtils.isNotEmpty((CharSequence)filter.values()[0].toString())) continue block16;
                            predicates.add(criteriaBuilder.lessThanOrEqualTo((Expression)path, (Comparable)value));
                            break;
                        }
                        case BETWEEN: {
                            logger.debug("case BETWEEN");
                            if (filter.values().length != 2) continue block16;
                            Object value1 = DynamicSpecifications.parseValue(path, filter.values()[0], true, BetweenType.LOW);
                            Object value2 = DynamicSpecifications.parseValue(path, filter.values()[1], true, BetweenType.HIGH);
                            if (value1 != null && value2 != null) {
                                if (!(value1 instanceof Comparable) || !(value2 instanceof Comparable)) continue block16;
                                predicates.add(criteriaBuilder.between((Expression)path, (Comparable)value1, (Comparable)value2));
                                break;
                            }
                            if (value1 != null) {
                                predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)path, (Comparable)value1));
                                break;
                            }
                            if (value2 == null) continue block16;
                            predicates.add(criteriaBuilder.lessThanOrEqualTo((Expression)path, (Comparable)value2));
                            break;
                        }
                        case IN: {
                            logger.debug("case IN");
                            if (filter.values() == null || filter.values().length <= 0) continue block16;
                            predicates.add(path.in((Object[])StringUtils.split((String)filter.values()[0].toString(), (char)',')));
                            break;
                        }
                        case NOTIN: {
                            logger.debug("case NOTIN");
                            if (filter.values() == null || filter.values().length <= 0) continue block16;
                            predicates.add(criteriaBuilder.not((Expression)path.in((Object[])StringUtils.split((String)filter.values()[0].toString(), (char)','))));
                            break;
                        }
                        case ISNULL: {
                            logger.debug("case IS NULL");
                            predicates.add(criteriaBuilder.isNull((Expression)path));
                            break;
                        }
                        case ISNOTNULL: {
                            logger.debug("case IS NOT NULL");
                            predicates.add(criteriaBuilder.isNotNull((Expression)path));
                            break;
                        }
                        default: {
                            throw new CustomizedException("\u9519\u8bef\u7684\u53c2\u6570");
                        }
                    }
                }
                if (!predicates.isEmpty()) {
                    return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
                }
            } else {
                logger.debug("filters == null");
            }
            return criteriaBuilder.conjunction();
        };
    }

    public static <T> Specification<T> mergeSpecification(Specification<T> firstSpecification, Specification<T> ... specifications) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList predicates = Lists.newArrayList((Object[])new Predicate[]{firstSpecification.toPredicate(root, criteriaQuery, criteriaBuilder)});
            if (specifications != null) {
                for (Specification specification : specifications) {
                    predicates.add(specification.toPredicate(root, criteriaQuery, criteriaBuilder));
                }
            }
            if (!predicates.isEmpty()) {
                return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
            }
            return criteriaBuilder.conjunction();
        };
    }

    public static Object parseValue(Class pathClass, Object objValue, boolean needComparable, BetweenType betweenType) {
        if (pathClass == null || objValue == null) {
            return null;
        }
        String strValue = objValue.toString();
        if (String.class.isAssignableFrom(pathClass)) {
            return objValue;
        }
        if (pathClass.isEnum()) {
            logger.debug("path is enum");
            try {
                return Enum.valueOf(pathClass, strValue);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        if (Date.class.isAssignableFrom(pathClass)) {
            try {
                if (betweenType != null) {
                    switch (betweenType) {
                        case LOW: {
                            return DynamicSpecifications.fromDate(strValue);
                        }
                        case HIGH: {
                            return DynamicSpecifications.toDate(strValue);
                        }
                    }
                    throw new CustomizedException("\u9519\u8bef\u7684\u53c2\u6570");
                }
                return DynamicSpecifications.date(strValue);
            }
            catch (ParseException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        if (Number.class.isAssignableFrom(pathClass)) {
            return NumberUtils.parseNumber((String)strValue, (Class)pathClass);
        }
        if (needComparable && !Comparable.class.isAssignableFrom(pathClass)) {
            return null;
        }
        return objValue;
    }

    private static Object parseValue(Path path, Object objValue, boolean needComparable, BetweenType betweenType) {
        if (path == null || objValue == null) {
            return null;
        }
        Class pathClass = path.getJavaType();
        return DynamicSpecifications.parseValue(pathClass, objValue, needComparable, betweenType);
    }

    private static Date date(String date) throws ParseException {
        return DateUtils.parseDateStrictly((String)date, (String[])PATTERNS);
    }

    private static Date betweenDate(String date, BetweenType betweenType) throws ParseException {
        if (Pattern.matches("\\d{4}-\\d{2}-\\d{2}\\s+\\d{2}:\\d{2}:\\d{2}", date)) {
            return DynamicSpecifications.date(date);
        }
        if (Pattern.matches("\\d{4}-\\d{2}-\\d{2}", date)) {
            Date fromDate = DynamicSpecifications.date(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(fromDate);
            switch (betweenType) {
                case LOW: {
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    break;
                }
                case HIGH: {
                    calendar.set(11, 23);
                    calendar.set(12, 59);
                    calendar.set(13, 59);
                    calendar.set(14, 999);
                    break;
                }
                default: {
                    throw new CustomizedException("\u9519\u8bef\u7684\u53c2\u6570");
                }
            }
            return calendar.getTime();
        }
        return null;
    }

    private static Date fromDate(String date) throws ParseException {
        return DynamicSpecifications.betweenDate(date, BetweenType.LOW);
    }

    private static Date toDate(String date) throws ParseException {
        return DynamicSpecifications.betweenDate(date, BetweenType.HIGH);
    }
}

