/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.envers.repository.impl;

import io.geewit.data.jpa.envers.EnversRevisionEntity;
import io.geewit.data.jpa.envers.domain.ComparedRevision;
import io.geewit.data.jpa.envers.repository.EnversRevisionMetadata;
import io.geewit.data.jpa.envers.repository.EnversRevisionRepository;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.AuditReaderFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.history.Revision;
import org.springframework.data.history.RevisionSort;
import org.springframework.data.history.Revisions;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.history.support.RevisionEntityInformation;
import org.springframework.util.Assert;

public class EnversRevisionRepositoryImpl<T, ID, O extends Serializable>
extends SimpleJpaRepository<T, ID>
implements EnversRevisionRepository<T, ID, O> {
    private final EntityInformation<T, ID> entityInformation;
    private final RevisionEntityInformation revisionEntityInformation;
    private final EntityManager entityManager;

    public EnversRevisionRepositoryImpl(JpaEntityInformation<T, ID> entityInformation, RevisionEntityInformation revisionEntityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        Assert.notNull((Object)revisionEntityInformation, (String)"[Assertion failed] - revisionEntityInformation must be null");
        this.entityInformation = entityInformation;
        this.revisionEntityInformation = revisionEntityInformation;
        this.entityManager = entityManager;
    }

    public Optional<Revision<Integer, T>> findLastChangeRevision(ID id) {
        Class type = this.entityInformation.getJavaType();
        AuditReader reader = AuditReaderFactory.get((EntityManager)this.entityManager);
        List revisions = reader.getRevisions(type, id);
        if (revisions.isEmpty()) {
            return Optional.empty();
        }
        Number latestRevision = (Number)revisions.get(revisions.size() - 1);
        EnversRevisionEntity revisionEntity = (EnversRevisionEntity)reader.findRevision(EnversRevisionEntity.class, latestRevision);
        EnversRevisionMetadata<O> metadata = this.getRevisionMetadata(revisionEntity);
        return Optional.of(Revision.of(metadata, (Object)reader.find(type, id, latestRevision)));
    }

    public Optional<Revision<Integer, T>> findRevision(ID id, Integer revisionNumber) {
        Assert.notNull(id, (String)"Identifier must not be null!");
        Assert.notNull((Object)revisionNumber, (String)"Revision number must not be null!");
        return this.getEntityForRevision(revisionNumber, id, AuditReaderFactory.get((EntityManager)this.entityManager));
    }

    public Revisions<Integer, T> findRevisions(ID id) {
        Class type = this.entityInformation.getJavaType();
        AuditReader reader = AuditReaderFactory.get((EntityManager)this.entityManager);
        List revisionNumbers = reader.getRevisions(type, id);
        return revisionNumbers.isEmpty() ? Revisions.none() : this.getEntitiesForRevisions(revisionNumbers, id, reader);
    }

    public Page<Revision<Integer, T>> findRevisions(ID id, Pageable pageable) {
        long offset;
        Class type = this.entityInformation.getJavaType();
        AuditReader reader = AuditReaderFactory.get((EntityManager)this.entityManager);
        List revisionNumbers = reader.getRevisions(type, id);
        boolean isDescending = RevisionSort.getRevisionDirection((Sort)pageable.getSort()).isDescending();
        if (isDescending) {
            Collections.reverse(revisionNumbers);
        }
        if ((offset = pageable.getOffset()) > (long)revisionNumbers.size()) {
            return new PageImpl(Collections.emptyList(), pageable, 0L);
        }
        long upperBound = Math.min((long)revisionNumbers.size(), offset + (long)pageable.getPageSize());
        List<Integer> subList = revisionNumbers.subList(Math.toIntExact(offset), Math.toIntExact(upperBound));
        Revisions revisions = this.getEntitiesForRevisions(subList, id, reader);
        revisions = isDescending ? revisions.reverse() : revisions;
        return new PageImpl(revisions.getContent(), pageable, (long)revisionNumbers.size());
    }

    @Override
    public Page<ComparedRevision<T, O>> findComparedRevisions(ID id, Pageable pageable) {
        Class type = this.entityInformation.getJavaType();
        AuditReader reader = AuditReaderFactory.get((EntityManager)this.entityManager);
        List revisionNumbers = reader.getRevisions(type, id);
        boolean isDescending = RevisionSort.getRevisionDirection((Sort)pageable.getSort()).isDescending();
        if (isDescending) {
            Collections.reverse(revisionNumbers);
        }
        long offset = pageable.getOffset();
        int revisionNumberSize = revisionNumbers.size();
        if (revisionNumberSize == 0 || offset > (long)revisionNumbers.size()) {
            return new PageImpl(Collections.emptyList(), pageable, 0L);
        }
        long upperBound = Math.min((long)revisionNumberSize, offset + (long)pageable.getPageSize());
        Number previousOfFirst = null;
        if (offset > 0L) {
            previousOfFirst = (Number)revisionNumbers.get(Math.toIntExact(offset - 1L));
        }
        List<Number> subList = revisionNumbers.subList(Math.toIntExact(offset), Math.toIntExact(upperBound));
        List<ComparedRevision<T, O>> comparedRevisions = this.getComparedEntitiesForRevisions(id, subList, previousOfFirst, reader);
        return new PageImpl(comparedRevisions, pageable, (long)revisionNumberSize);
    }

    @Override
    public T findRevisionByLastUpdateTime(ID id, Date updateTime) {
        Class type = this.entityInformation.getJavaType();
        AuditReader reader = AuditReaderFactory.get((EntityManager)this.entityManager);
        return (T)reader.find(type, id, updateTime);
    }

    private Revisions<Integer, T> getEntitiesForRevisions(Collection<Integer> revisionNumbers, ID id, AuditReader reader) {
        Class type = this.entityInformation.getJavaType();
        Class revisionEntityClass = this.revisionEntityInformation.getRevisionEntityClass();
        Map revisionEntities = reader.findRevisions(revisionEntityClass, new HashSet<Integer>(revisionNumbers));
        Map revisions = revisionNumbers.stream().collect(Collectors.toMap(number -> number, number -> reader.find(type, id, (Number)number), (a, b) -> b, () -> new HashMap(revisionNumbers.size())));
        return Revisions.of(this.toRevisions(revisions, revisionEntities));
    }

    private List<ComparedRevision<T, O>> getComparedEntitiesForRevisions(ID id, List<Number> revisionNumbers, Number previousOfFirst, AuditReader reader) {
        Class type = this.entityInformation.getJavaType();
        ArrayList<ComparedRevision<T, O>> list = new ArrayList<ComparedRevision<T, O>>(revisionNumbers.size());
        HashSet<Number> revisionNumberSet = new HashSet<Number>(revisionNumbers);
        if (previousOfFirst != null) {
            revisionNumberSet.add(previousOfFirst);
        }
        Map revisionEntities = reader.findRevisions(EnversRevisionEntity.class, revisionNumberSet);
        Object current = null;
        Object previous = null;
        int revisionNumbersSize = revisionNumbers.size();
        for (int i = 0; i < revisionNumbersSize; ++i) {
            if (i == 0) {
                if (previousOfFirst != null) {
                    previous = reader.find(type, id, previousOfFirst);
                }
            } else {
                previous = current;
            }
            current = reader.find(type, id, revisionNumbers.get(i));
            EnversRevisionMetadata<O> metadata = this.getRevisionMetadata((EnversRevisionEntity)revisionEntities.get(revisionNumbers.get(i)));
            Instant updateJodaTime = metadata.getRevisionInstant().isPresent() ? metadata.getRevisionInstant().get() : null;
            O operatorId = metadata.getOperatorId();
            String operatorName = metadata.getOperatorName();
            ComparedRevision<Object, O> comparedRevision = new ComparedRevision<Object, O>(current, previous, updateJodaTime, operatorId, operatorName);
            list.add(comparedRevision);
        }
        return list;
    }

    private Optional<Revision<Integer, T>> getEntityForRevision(Integer revisionNumber, ID id, AuditReader reader) {
        EnversRevisionEntity revision = (EnversRevisionEntity)reader.findRevision(EnversRevisionEntity.class, (Number)revisionNumber);
        Object entity = reader.find(this.entityInformation.getJavaType(), id, (Number)revisionNumber);
        return Optional.of(Revision.of(this.getRevisionMetadata(revision), (Object)entity));
    }

    private List<Revision<Integer, T>> toRevisions(Map<Integer, T> source, Map<Number, T> revisionEntities) {
        ArrayList<Revision> result = new ArrayList<Revision>();
        for (Map.Entry<Integer, T> revision : source.entrySet()) {
            Integer revisionNumber = revision.getKey();
            T entity = revision.getValue();
            EnversRevisionMetadata<O> metadata = this.getRevisionMetadata((EnversRevisionEntity)revisionEntities.get(revisionNumber));
            result.add(Revision.of(metadata, entity));
        }
        Collections.sort(result);
        return Collections.unmodifiableList(result);
    }

    private EnversRevisionMetadata<O> getRevisionMetadata(EnversRevisionEntity<O> revisionEntity) {
        return new EnversRevisionMetadata<O>(revisionEntity);
    }
}

