/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.envers.repository;

import io.geewit.data.jpa.envers.EnversRevisionEntity;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Optional;
import org.hibernate.envers.RevisionNumber;
import org.hibernate.envers.RevisionTimestamp;
import org.springframework.data.history.RevisionMetadata;
import org.springframework.data.util.AnnotationDetectionFieldCallback;
import org.springframework.data.util.Lazy;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class EnversRevisionMetadata<O extends Serializable>
implements RevisionMetadata<Integer> {
    private final EnversRevisionEntity<O> entity;
    private final Lazy<Optional<Integer>> revisionNumber;
    private final Lazy<Optional<Object>> revisionDate;

    public EnversRevisionMetadata(EnversRevisionEntity<O> entity) {
        Assert.notNull(entity, (String)"[Assertion failed] - DefaultRevisionEntity argument must be null");
        this.entity = entity;
        this.revisionNumber = EnversRevisionMetadata.detectAnnotation(entity, RevisionNumber.class);
        this.revisionDate = EnversRevisionMetadata.detectAnnotation(entity, RevisionTimestamp.class);
    }

    public Optional<Integer> getRevisionNumber() {
        return (Optional)this.revisionNumber.get();
    }

    public Optional<LocalDateTime> getRevisionDate() {
        return ((Optional)this.revisionDate.get()).map(EnversRevisionMetadata::convertToLocalDateTime);
    }

    public Optional<Instant> getRevisionInstant() {
        return ((Optional)this.revisionDate.get()).map(EnversRevisionMetadata::convertToInstant);
    }

    public O getOperatorId() {
        return this.entity.getOperatorId();
    }

    public String getOperatorName() {
        return this.entity.getOperatorName();
    }

    public <T> T getDelegate() {
        return (T)this.entity;
    }

    private static <T> Lazy<Optional<T>> detectAnnotation(Object entity, Class<? extends Annotation> annotationType) {
        return Lazy.of(() -> {
            AnnotationDetectionFieldCallback callback = new AnnotationDetectionFieldCallback(annotationType);
            ReflectionUtils.doWithFields(entity.getClass(), (ReflectionUtils.FieldCallback)callback);
            return Optional.ofNullable(callback.getValue(entity));
        });
    }

    private static LocalDateTime convertToLocalDateTime(Object timestamp) {
        if (timestamp instanceof LocalDateTime) {
            return (LocalDateTime)timestamp;
        }
        return LocalDateTime.ofInstant(EnversRevisionMetadata.convertToInstant(timestamp), ZoneOffset.systemDefault());
    }

    private static Instant convertToInstant(Object timestamp) {
        if (timestamp instanceof Instant) {
            return (Instant)timestamp;
        }
        if (timestamp instanceof LocalDateTime) {
            return ((LocalDateTime)timestamp).atZone(ZoneOffset.systemDefault()).toInstant();
        }
        if (timestamp instanceof Long) {
            return Instant.ofEpochMilli((Long)timestamp);
        }
        if (Date.class.isInstance(timestamp)) {
            return ((Date)Date.class.cast(timestamp)).toInstant();
        }
        throw new IllegalArgumentException(String.format("Can't convert %s to Instant!", timestamp));
    }
}

