/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.data.jpa.envers.repository;

import io.geewit.data.jpa.envers.repository.EnversRevisionEntityInformation;
import io.geewit.data.jpa.envers.repository.EnversRevisionRepository;
import io.geewit.data.jpa.envers.repository.impl.EnversRevisionRepositoryImpl;
import java.io.Serializable;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class EnversRevisionRepositoryFactoryBean<T extends EnversRevisionRepository<S, ID, O>, S, ID, O extends Serializable>
extends JpaRepositoryFactoryBean<T, S, ID> {
    public EnversRevisionRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    protected RepositoryFactorySupport createRepositoryFactory(EntityManager entityManager) {
        return new RevisionRepositoryFactory(entityManager);
    }

    private static class RevisionRepositoryFactory<T, ID, O extends Serializable>
    extends JpaRepositoryFactory {
        private final EnversRevisionEntityInformation revisionEntityInformation;
        private final EntityManager entityManager;

        public RevisionRepositoryFactory(EntityManager entityManager) {
            super(entityManager);
            this.entityManager = entityManager;
            this.revisionEntityInformation = new EnversRevisionEntityInformation();
        }

        protected EnversRevisionRepositoryImpl<T, ID, O> getTargetRepository(RepositoryInformation information, EntityManager entityManager) {
            JpaEntityInformation entityInformation = this.getEntityInformation(information.getDomainType());
            return new EnversRevisionRepositoryImpl(entityInformation, this.revisionEntityInformation, entityManager);
        }

        protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
            return EnversRevisionRepositoryImpl.class;
        }

        public <I> I getRepository(Class<I> repositoryInterface, RepositoryComposition.RepositoryFragments fragments) {
            if (EnversRevisionRepository.class.isAssignableFrom(repositoryInterface) && !this.revisionEntityInformation.getRevisionNumberType().equals(Integer.class)) {
                throw new IllegalStateException(String.format("Configured a revision entity type of %s with a revision type of %s but the repository interface is typed to a revision type of %s!", repositoryInterface, this.revisionEntityInformation.getRevisionNumberType(), Integer.class));
            }
            return (I)super.getRepository(repositoryInterface, fragments);
        }
    }
}

