/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.boot.stringtemplate.service;

import io.geewit.boot.stringtemplate.StringTemplateProperties;
import io.geewit.boot.stringtemplate.utils.StringTemplateUtils;
import io.geewit.core.utils.lang.reflection.BeanUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class StringTemplateService {
    private static final Logger logger = LoggerFactory.getLogger(StringTemplateService.class);
    private final ResourceLoader resourceLoader;
    private final StringTemplateProperties stringTemplateProperties;

    public StringTemplateService(ResourceLoader resourceLoader, StringTemplateProperties stringTemplateProperties) {
        this.resourceLoader = resourceLoader;
        this.stringTemplateProperties = stringTemplateProperties;
    }

    public String render(String templateName, Map<String, Object> params) {
        String template = this.getTemplate(templateName);
        if (template == null) {
            return null;
        }
        String rendered = StringTemplateUtils.render(template, params);
        logger.debug("rendered : " + rendered);
        return rendered;
    }

    public String render(String templateName, Object paramObject) {
        String template = this.getTemplate(templateName);
        if (template == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        BeanUtils.copyProperties((Object)paramObject, params);
        String rendered = StringTemplateUtils.render(template, params);
        logger.debug("rendered : " + rendered);
        return rendered;
    }

    private String getTemplate(String templateName) {
        logger.debug("templateName : " + templateName);
        String templatePath = this.stringTemplateProperties.getRootPath() + templateName + ".tpl";
        Resource resource = this.resourceLoader.getResource("classpath:" + templatePath);
        try {
            String template = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
            logger.debug("template : " + template);
            return template;
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

