/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.spring.boot.autoconfigure.nashorn;

import io.geewit.spring.boot.autoconfigure.nashorn.service.ScriptEvalService;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import jdk.nashorn.api.scripting.NashornScriptEngine;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.PropertyResolver;

@Configuration
@ConditionalOnClass(value={ScriptEngine.class})
public class NashornAutoConfigure {
    @ConditionalOnMissingBean(value={ScriptEngineManager.class})
    @Bean
    public ScriptEngineManager scriptEngineManager() {
        return new ScriptEngineManager();
    }

    private NashornScriptEngine scriptEngine() {
        NashornScriptEngine scriptEngine = (NashornScriptEngine)this.scriptEngineManager().getEngineByName("nashorn");
        return scriptEngine;
    }

    @ConditionalOnMissingBean
    @Bean
    public ScriptEvalService scriptEvalService(ObjectProvider<PropertyResolver> propertyResolverProvider) {
        PropertyResolver propertyResolver = (PropertyResolver)propertyResolverProvider.getIfAvailable();
        ScriptEvalService scriptEvalService = new ScriptEvalService(this.scriptEngine(), propertyResolver);
        return scriptEvalService;
    }
}

