/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.boot.aliyun.oss.impl;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import io.geewit.boot.aliyun.oss.ByteArrayDataSource;
import io.geewit.boot.aliyun.oss.FileStorageService;
import io.geewit.utils.uuid.UUID;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import javax.activation.DataSource;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class FileStorageServiceOssImpl
implements FileStorageService {
    private String bucketName;
    private static MimetypesFileTypeMap fileTypeMap = new MimetypesFileTypeMap();
    public static final AtomicLong fileUploadSuccess = new AtomicLong();
    public static final AtomicLong fileUploadFail = new AtomicLong();
    public static final AtomicLong fileGetCounts = new AtomicLong();
    public static final AtomicLong fileDeleteCounts = new AtomicLong();
    private final OSSClient ossClient;

    public FileStorageServiceOssImpl(OSSClient ossClient) {
        this.ossClient = ossClient;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public String save(DataSource ds) throws IOException {
        String newName = FileStorageServiceOssImpl.getUuidName(ds.getName());
        byte[] content = IOUtils.toByteArray((InputStream)ds.getInputStream());
        this.upload(this.bucketName, newName, content);
        return newName;
    }

    @Override
    public String saveToDirectory(String directory, DataSource ds) throws IOException {
        String newName = directory + "/" + FileStorageServiceOssImpl.getUuidName(ds.getName());
        byte[] content = IOUtils.toByteArray((InputStream)ds.getInputStream());
        this.upload(this.bucketName, newName, content);
        return newName;
    }

    @Override
    public void delete(String fileName) {
        this.ossClient.deleteObject(this.bucketName, fileName);
        fileDeleteCounts.incrementAndGet();
    }

    @Override
    public DataSource get(String fileName) throws IOException {
        OSSObject ossObject = this.ossClient.getObject(this.bucketName, fileName);
        if (ossObject != null) {
            ByteArrayDataSource ds = new ByteArrayDataSource(IOUtils.toByteArray((InputStream)ossObject.getObjectContent()), this.getContentType(fileName));
            ds.setName(fileName);
            fileGetCounts.incrementAndGet();
            return ds;
        }
        return null;
    }

    @Override
    public void rename(String oldName, String newName) {
        boolean keyExists = true;
        try {
            this.ossClient.getObjectMetadata(this.bucketName, oldName);
        }
        catch (Exception e) {
            keyExists = false;
        }
        if (keyExists) {
            this.ossClient.copyObject(this.bucketName, oldName, this.bucketName, newName);
        }
    }

    private static String getUuidName(String name) {
        String extension;
        String uuid;
        String newName = uuid = UUID.randomUUID().toString();
        if (name != null && name.contains(".") && StringUtils.isNotEmpty((CharSequence)(extension = StringUtils.substringAfterLast((String)name, (String)".")))) {
            newName = uuid + "." + extension;
        }
        return newName;
    }

    private void upload(String bucketName, String fileName, byte[] content) {
        ObjectMetadata metadata = new ObjectMetadata();
        ByteArrayInputStream bis = new ByteArrayInputStream(content);
        try {
            metadata.setContentType(this.getContentType(fileName));
            metadata.setContentLength((long)content.length);
            metadata.setCacheControl("public, max-age=31536000");
            this.ossClient.putObject(bucketName, fileName, (InputStream)bis, metadata);
            fileUploadSuccess.incrementAndGet();
        }
        catch (Exception ignore) {
            this.ossClient.putObject(bucketName, fileName, (InputStream)bis, metadata);
            fileUploadFail.incrementAndGet();
        }
    }

    private String getContentType(String fileNameOrExt) {
        if (fileNameOrExt == null || fileNameOrExt.isEmpty()) {
            return "application/octet-stream";
        }
        return fileTypeMap.getContentType(fileNameOrExt.toLowerCase());
    }
}

