/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.boot.aliyun.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.AccessControlList;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.StorageClass;
import io.geewit.boot.aliyun.AliyunProperties;
import io.geewit.boot.aliyun.oss.AliyunOssProperties;
import io.geewit.boot.aliyun.oss.FileStorageService;
import io.geewit.boot.aliyun.oss.impl.FileStorageServiceOssImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnClass(value={OSSClient.class})
@EnableConfigurationProperties(value={AliyunProperties.class, AliyunOssProperties.class})
public class AliyunOssAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(AliyunOssAutoConfiguration.class);
    private final Environment environment;
    private final AliyunProperties properties;
    private final AliyunOssProperties ossProperties;

    public AliyunOssAutoConfiguration(Environment environment, AliyunProperties properties, AliyunOssProperties ossProperties) {
        this.environment = environment;
        this.properties = properties;
        this.ossProperties = ossProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public OSSClient ossClient() {
        ClientConfiguration config = new ClientConfiguration();
        if (this.ossProperties.getTimeout() != null && this.ossProperties.getTimeout() > 0) {
            config.setConnectionTimeout(this.ossProperties.getTimeout().intValue());
            config.setSocketTimeout(this.ossProperties.getTimeout().intValue());
            config.setRequestTimeout(this.ossProperties.getTimeout().intValue());
            config.setConnectionRequestTimeout(this.ossProperties.getTimeout().intValue());
        }
        return new OSSClient(this.ossProperties.getEndpoint(), this.properties.getKey(), this.properties.getSecret(), config);
    }

    @Bean
    @ConditionalOnMissingBean
    public FileStorageService fileStorageService() {
        String bucketName;
        OSSClient ossClient = this.ossClient();
        boolean exists = ossClient.doesBucketExist(bucketName = this.environment.getActiveProfiles()[0] + "-" + this.ossProperties.getBucket());
        if (exists) {
            logger.debug("bucket: [" + bucketName + "]\u5df2\u7ecf\u5b58\u5728");
            AccessControlList accessControlList = ossClient.getBucketAcl(bucketName);
            CannedAccessControlList existsCannedACL = accessControlList.getCannedACL();
            if (CannedAccessControlList.PublicRead.equals((Object)existsCannedACL)) {
                logger.debug("\u6743\u9650\u5df2\u7ecf\u4e3a PublicRead");
            } else {
                logger.debug("\u8bbe\u7f6e\u6743\u9650\u4e3a PublicRead");
                ossClient.setBucketAcl(bucketName, CannedAccessControlList.PublicRead);
            }
            ObjectMetadata metadata = new ObjectMetadata();
            ByteArrayInputStream bis = new ByteArrayInputStream(new byte[0]);
            try {
                metadata.setContentType("text/plain");
                metadata.setContentLength(0L);
                metadata.setCacheControl("public, max-age=31536000");
                ossClient.putObject(bucketName, "ok.txt", (InputStream)bis, metadata);
            }
            catch (Exception ignore) {
                ossClient.putObject(bucketName, "ok.txt", (InputStream)bis, metadata);
            }
        } else {
            logger.debug("bucket: [" + bucketName + "]\u4e0d\u5b58\u5728, \u521b\u5efa\u5e76\u8bbe\u7f6e\u6743\u9650 PublicRead");
            CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
            createBucketRequest.setCannedACL(CannedAccessControlList.PublicRead);
            createBucketRequest.setStorageClass(StorageClass.IA);
            ossClient.createBucket(createBucketRequest);
        }
        FileStorageServiceOssImpl fileStorageServiceOss = new FileStorageServiceOssImpl(ossClient);
        fileStorageServiceOss.setBucketName(bucketName);
        return fileStorageServiceOss;
    }
}

