/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.boot.aliyun.dysms.service;

import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import io.geewit.boot.aliyun.AliyunProperties;
import io.geewit.boot.aliyun.dysms.AliyunDySmsProperties;
import io.geewit.utils.uuid.UUIDUtils;
import io.geewit.web.utils.JsonUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SmsSender {
    private static final Logger logger = LoggerFactory.getLogger(SmsSender.class);
    private final AliyunProperties properties;
    private final AliyunDySmsProperties aliyunDySmsProperties;

    public SmsSender(AliyunProperties properties, AliyunDySmsProperties aliyunDySmsProperties) {
        this.properties = properties;
        this.aliyunDySmsProperties = aliyunDySmsProperties;
    }

    public CommonResponse sendSms(String templateCode, Map<String, String> params, List<String> receivers) throws ClientException {
        String regionId = this.aliyunDySmsProperties.getRegionId();
        logger.debug("regionId : " + regionId);
        String endpoint = this.aliyunDySmsProperties.getEndpoint();
        logger.debug("endpoint : " + endpoint);
        DefaultProfile profile = DefaultProfile.getProfile((String)regionId, (String)this.properties.getKey(), (String)this.properties.getSecret());
        DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain(endpoint);
        request.setSysVersion("2017-05-25");
        request.setSysAction("SendSms");
        request.putQueryParameter("RegionId", regionId);
        String sign = this.aliyunDySmsProperties.getSign();
        logger.debug("sign : " + sign);
        request.putQueryParameter("SignName", sign);
        logger.debug("templateCode : " + templateCode);
        request.putQueryParameter("TemplateCode", templateCode);
        String phoneNumbers = StringUtils.join((Object[])receivers.toArray(), (String)",");
        logger.debug("phoneNumbers : " + phoneNumbers);
        request.putQueryParameter("PhoneNumbers", phoneNumbers);
        String templateParam = JsonUtils.toJson(params);
        logger.debug("templateParam : " + templateParam);
        request.putQueryParameter("TemplateParam", templateParam);
        String outId = UUIDUtils.randomUUID();
        logger.debug("outId : " + outId);
        request.putQueryParameter("OutId", outId);
        CommonResponse response = acsClient.getCommonResponse(request);
        logger.debug("response : " + response.getData());
        return response;
    }
}

