/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.boot.aliyun.dm.service;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dm.model.v20151123.SingleSendMailRequest;
import com.aliyuncs.dm.model.v20151123.SingleSendMailResponse;
import com.aliyuncs.exceptions.ClientException;
import io.geewit.boot.aliyun.dm.configuration.AliyunDmProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;

public class MailService {
    private static final Logger logger = LoggerFactory.getLogger(MailService.class);
    private final IAcsClient iAcsClient;
    private final AliyunDmProperties dmProperties;

    public MailService(IAcsClient iAcsClient, AliyunDmProperties dmProperties) {
        this.iAcsClient = iAcsClient;
        this.dmProperties = dmProperties;
    }

    @Async
    public SingleSendMailResponse sendMail(String accountName, String fromAlias, String tagName, String toAddress, String subject, String htmlBody) throws ClientException {
        if (!this.dmProperties.getEnable()) {
            return null;
        }
        logger.debug("send mail request, accountName = " + accountName + ", fromAlias = " + fromAlias + ", tagName = " + tagName + ", toAddress = " + toAddress + ", subject = " + subject);
        SingleSendMailRequest request = new SingleSendMailRequest();
        request.setAccountName(accountName);
        request.setFromAlias(fromAlias);
        request.setAddressType(Integer.valueOf(1));
        request.setTagName(tagName);
        request.setReplyToAddress(Boolean.valueOf(true));
        request.setToAddress(toAddress);
        request.setSubject(subject);
        request.setHtmlBody(htmlBody);
        try {
            SingleSendMailResponse httpResponse = (SingleSendMailResponse)this.iAcsClient.getAcsResponse((AcsRequest)request);
            logger.debug("send mail response : { envId = " + httpResponse.getEnvId() + ", requestId = " + httpResponse.getRequestId() + "}");
            return httpResponse;
        }
        catch (ClientException e) {
            logger.warn("send mail " + e.getErrorType().name() + "." + e.getErrMsg() + "(" + e.getErrCode() + "), requestId: " + e.getRequestId());
            throw e;
        }
    }

    public SingleSendMailResponse sendMail(String tagName, String toAddress, String subject, String htmlBody) throws ClientException {
        String accountName = this.dmProperties.getAccountName();
        String fromAlias = this.dmProperties.getFromAlias();
        return this.sendMail(accountName, fromAlias, tagName, toAddress, subject, htmlBody);
    }

    public SingleSendMailResponse sendMail(String toAddress, String subject, String htmlBody) throws ClientException {
        String accountName = this.dmProperties.getAccountName();
        String fromAlias = this.dmProperties.getFromAlias();
        return this.sendMail(accountName, fromAlias, null, toAddress, subject, htmlBody);
    }
}

