/*
 * Decompiled with CFR 0.152.
 */
package io.geewit.boot.aliyun.dm.configuration;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dm.HangZhouDmClient;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import io.geewit.boot.aliyun.AliyunProperties;
import io.geewit.boot.aliyun.dm.configuration.AliyunDmProperties;
import io.geewit.boot.aliyun.dm.service.MailService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={IClientProfile.class, HangZhouDmClient.class})
@EnableConfigurationProperties(value={AliyunProperties.class, AliyunDmProperties.class})
public class AliyunDmAutoConfiguration {
    private final AliyunProperties properties;
    private final AliyunDmProperties dmProperties;

    public AliyunDmAutoConfiguration(AliyunProperties properties, AliyunDmProperties dmProperties) {
        this.properties = properties;
        this.dmProperties = dmProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public IAcsClient iAcsClient() {
        HangZhouDmClient dmClient = new HangZhouDmClient(this.properties.getKey(), this.properties.getSecret());
        DefaultProfile profile = DefaultProfile.getProfile((String)dmClient.getRegion(), (String)this.properties.getKey(), (String)this.properties.getSecret());
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        return client;
    }

    @Bean
    @ConditionalOnMissingBean
    public MailService mailService() {
        MailService mailService = new MailService(this.iAcsClient(), this.dmProperties);
        return mailService;
    }
}

