/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server.servlets;

import java.lang.reflect.Constructor;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swordapp.server.SwordConfiguration;

public class SwordServlet
extends HttpServlet {
    private static Logger log = LoggerFactory.getLogger(SwordServlet.class);
    protected SwordConfiguration config;

    public void init() throws ServletException {
        this.config = (SwordConfiguration)this.loadImplClass("config-impl", false);
    }

    protected Object loadImplClass(String paramName, boolean allowNull) throws ServletException {
        String className = this.getServletContext().getInitParameter(paramName);
        if (className == null) {
            if (allowNull) {
                return null;
            }
            log.error("'" + paramName + "' init parameter not set in Servlet context");
            throw new ServletException("'" + paramName + "' init parameter not set in Servlet context");
        }
        try {
            Constructor<?>[] constructors = Class.forName(className).getConstructors();
            Constructor<?> zeroConstructor = null;
            for (Constructor<?> i : constructors) {
                if (i.getParameterCount() != 0) continue;
                zeroConstructor = i;
                break;
            }
            if (zeroConstructor == null) {
                throw new IllegalArgumentException("Cannot find a public zero args constructor.");
            }
            Object obj = zeroConstructor.newInstance(new Object[0]);
            log.info("Using " + className + " as '" + paramName + "'");
            return obj;
        }
        catch (Exception e) {
            log.error("Unable to instantiate class from '" + paramName + "': " + className);
            throw new ServletException("Unable to instantiate class from '" + paramName + "': " + className, (Throwable)e);
        }
    }
}

