/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;

public class SwordEntry {
    private final Entry entry;

    public SwordEntry(Entry entry) {
        this.entry = entry;
    }

    public String getTitle() {
        return this.entry.getTitle();
    }

    public String getSummary() {
        return this.entry.getSummary();
    }

    public Entry getEntry() {
        return this.entry;
    }

    public String toString() {
        try {
            StringWriter stringWriter = new StringWriter();
            this.entry.writeTo((Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, List<String>> getDublinCore() {
        HashMap<String, List<String>> dc = new HashMap<String, List<String>>();
        List extensions = this.entry.getExtensions();
        for (Element element : extensions) {
            if (!"http://purl.org/dc/terms/".equals(element.getQName().getNamespaceURI())) continue;
            String field = element.getQName().getLocalPart();
            String value = element.getText();
            if (dc.containsKey(field)) {
                ((List)dc.get(field)).add(value);
                continue;
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            dc.put(field, values);
        }
        return dc;
    }
}

