/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Generator;
import org.apache.abdera.parser.ParseException;
import org.apache.abdera.parser.Parser;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ParameterParser;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swordapp.server.AuthCredentials;
import org.swordapp.server.ChecksumUtils;
import org.swordapp.server.Deposit;
import org.swordapp.server.ErrorDocument;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordConfiguration;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class SwordAPIEndpoint {
    protected final SwordConfiguration config;
    private static Logger log = LoggerFactory.getLogger(SwordAPIEndpoint.class);

    protected SwordAPIEndpoint(SwordConfiguration config) {
        this.config = config;
    }

    public void get(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setCharacterEncoding("UTF-8");
    }

    public void post(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setCharacterEncoding("UTF-8");
    }

    public void put(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setCharacterEncoding("UTF-8");
    }

    public void delete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setCharacterEncoding("UTF-8");
    }

    protected AuthCredentials getAuthCredentials(HttpServletRequest request) throws SwordAuthException {
        return this.getAuthCredentials(request, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AuthCredentials getAuthCredentials(HttpServletRequest request, boolean allowUnauthenticated) throws SwordAuthException {
        AuthCredentials auth = null;
        String authType = this.config.getAuthType();
        String obo = "";
        log.info("Auth type = " + authType);
        if (!authType.equalsIgnoreCase("none")) {
            String authHeader = request.getHeader("Authorization");
            obo = request.getHeader("On-Behalf-Of");
            boolean isBasic = authType.equalsIgnoreCase("basic");
            if (isBasic && (authHeader == null || authHeader.equals(""))) {
                if (!allowUnauthenticated) throw new SwordAuthException(true);
                log.debug("No Authentication Credentials supplied/required");
                return new AuthCredentials(null, null, obo);
            }
            if (!isBasic) throw new SwordAuthException("Server is not properly configured for authentication");
            String[] userPass = this.decodeAuthHeader(authHeader);
            return new AuthCredentials(userPass[0], userPass[1], obo);
        }
        log.debug("No Authentication Credentials supplied/required");
        return new AuthCredentials(null, null, obo);
    }

    protected String[] decodeAuthHeader(String encodedHeader) throws SwordAuthException {
        String[] authBits = encodedHeader.split(" ");
        if (authBits.length != 2) {
            log.error("Malformed Authorization header");
            throw new SwordAuthException("Malformed Authorization header");
        }
        if (!"Basic".equalsIgnoreCase(authBits[0].trim())) {
            log.warn("Authentication method not supported: " + authBits[0]);
            throw new SwordAuthException("Authentication method not supported: " + authBits[0]);
        }
        byte[] base64Creds = authBits[1].trim().getBytes(StandardCharsets.UTF_8);
        String unencodedCreds = new String(Base64.getDecoder().decode(base64Creds), StandardCharsets.UTF_8);
        String[] userPass = unencodedCreds.split(":", 2);
        if (userPass.length != 2) {
            log.error("Malformed Authorization header; unable to determine username/password boundary");
            throw new SwordAuthException("Malformed Authorization header; unable to determine username/password boundary");
        }
        return userPass;
    }

    protected String getFullUrl(HttpServletRequest req) {
        Object url = req.getRequestURL().toString();
        String q = req.getQueryString();
        if (q != null && !"".equals(q)) {
            url = (String)url + "?" + q;
        }
        return url;
    }

    protected void storeAndCheckBinary(Deposit deposit, SwordConfiguration config) throws SwordServerException, SwordError {
        if (deposit.getInputStream() == null) {
            throw new SwordServerException("Attempting to store and check deposit which has no input stream");
        }
        if (!config.storeAndCheckBinary()) {
            return;
        }
        String tempDirectory = config.getTempDirectory();
        if (tempDirectory == null) {
            throw new SwordServerException("Store and Check operation requested, but no tempDirectory specified in config");
        }
        String filename = tempDirectory + File.separator + "SWORD-" + UUID.randomUUID();
        try (InputStream inputStream = deposit.getInputStream();
             FileOutputStream outputStream = new FileOutputStream(filename);){
            String receivedMD5 = ChecksumUtils.hashAndCopy(inputStream, outputStream);
            log.debug("Received filechecksum: " + receivedMD5);
            String md5 = deposit.getMd5();
            log.debug("Received file checksum header: " + md5);
            if (md5 != null && !md5.equals(receivedMD5)) {
                log.debug("Bad MD5 for file. Aborting with appropriate error message");
                String msg = "The received MD5 checksum for the deposited file did not match the checksum sent by the deposit client";
                throw new SwordError("http://purl.org/net/sword/error/ErrorChecksumMismatch", msg);
            }
        }
        catch (IOException e) {
            throw new SwordServerException(e);
        }
        File file = new File(filename);
        deposit.setFile(file);
        long fLength = file.length();
        if (config.getMaxUploadSize() != -1 && fLength > (long)config.getMaxUploadSize()) {
            String msg = "The uploaded file exceeded the maximum file size this server will accept (the file is " + fLength + " bytes but the server will only accept files as large as " + config.getMaxUploadSize() + " bytes)";
            throw new SwordError("http://purl.org/net/sword/error/MaxUploadSizeExceeded", msg);
        }
        log.debug("Package temporarily stored as: " + filename);
    }

    protected void addDepositPropertiesFromMultipart(Deposit deposit, HttpServletRequest req) throws ServletException, IOException, SwordError {
        List<FileItem> items = this.getPartsFromRequest(req);
        for (FileItem item : items) {
            String contentDisposition = item.getHeaders().getHeader("Content-Disposition");
            String name = this.getContentDispositionValue(contentDisposition, "name");
            if ("atom".equals(name)) {
                this.parseEntryFromInputStream(deposit, item.getInputStream());
                continue;
            }
            if (!"payload".equals(name)) continue;
            String md5 = item.getHeaders().getHeader("Content-MD5");
            String packaging = item.getHeaders().getHeader("Packaging");
            String filename = this.getContentDispositionValue(contentDisposition, "filename");
            if (filename == null || "".equals(filename)) {
                throw new SwordError("http://purl.org/net/sword/error/ErrorBadRequest", "Filename could not be extracted from Content-Disposition");
            }
            String ct = item.getContentType();
            String mimeType = "application/octet-stream";
            if (ct != null) {
                String[] bits = ct.split(";");
                mimeType = bits[0].trim();
            }
            InputStream mediaPart = item.getInputStream();
            deposit.setFilename(filename);
            deposit.setInputStream(mediaPart);
            deposit.setMimeType(mimeType);
            deposit.setMd5(md5);
            deposit.setPackaging(packaging);
        }
        try {
            this.storeAndCheckBinary(deposit, this.config);
        }
        catch (SwordServerException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void cleanup(Deposit deposit) {
        if (deposit == null) {
            return;
        }
        File tmp = deposit.getFile();
        if (tmp == null) {
            return;
        }
        if (!tmp.delete()) {
            log.error("Could not delete temporary deposit file " + tmp.getAbsolutePath());
        }
        deposit.setFile(null);
    }

    protected Element getGenerator(SwordConfiguration config) {
        String generatorUri = config.generator();
        String generatorVersion = config.generatorVersion();
        String adminEmail = config.administratorEmail();
        if (generatorUri != null && !"".equals(generatorUri)) {
            Abdera abdera = new Abdera();
            Generator generator = abdera.getFactory().newGenerator();
            generator.setAttributeValue("uri", generatorUri);
            if (generatorVersion != null) {
                generator.setAttributeValue("version", generatorVersion);
            }
            if (adminEmail != null && !"".equals(adminEmail)) {
                generator.setText(adminEmail);
            }
            return generator;
        }
        return null;
    }

    protected void addDepositPropertiesFromEntry(Deposit deposit, HttpServletRequest req) throws IOException, SwordError {
        this.parseEntryFromInputStream(deposit, (InputStream)req.getInputStream());
    }

    private void parseEntryFromInputStream(Deposit deposit, InputStream entryPart) throws SwordError {
        Abdera abdera = new Abdera();
        Parser parser = abdera.getParser();
        Document entryDoc = null;
        try {
            entryDoc = parser.parse(entryPart);
        }
        catch (ParseException ex) {
            throw new SwordError("http://purl.org/net/sword/error/ErrorBadRequest", "Unable to parse SWORD entry", (Throwable)ex);
        }
        Entry entry = (Entry)entryDoc.getRoot();
        deposit.setEntry(entry);
    }

    protected void addDepositPropertiesFromBinary(Deposit deposit, HttpServletRequest req) throws ServletException, IOException, SwordError {
        String contentType = this.getContentType(req);
        String contentDisposition = req.getHeader("Content-Disposition");
        String md5 = req.getHeader("Content-MD5");
        String packaging = req.getHeader("Packaging");
        if (packaging == null || "".equals(packaging)) {
            packaging = "http://purl.org/net/sword/package/Binary";
        }
        long len = -1L;
        if (req.getHeader("Content-Length") != null) {
            try {
                len = Long.parseLong(req.getHeader("Content-Length"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ServletInputStream file = req.getInputStream();
        String filename = this.getContentDispositionValue(contentDisposition, "filename");
        if (filename == null || "".equals(filename)) {
            throw new SwordError("http://purl.org/net/sword/error/ErrorBadRequest", "Filename could not be extracted from Content-Disposition");
        }
        deposit.setFilename(filename);
        deposit.setMd5(md5);
        deposit.setPackaging(packaging);
        deposit.setInputStream((InputStream)file);
        deposit.setMimeType(contentType);
        deposit.setContentLength(len);
        try {
            this.storeAndCheckBinary(deposit, this.config);
        }
        catch (SwordServerException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void swordError(HttpServletRequest req, HttpServletResponse resp, SwordError e) throws IOException, ServletException {
        try {
            if (!this.config.returnErrorBody() || !e.hasBody()) {
                ErrorDocument doc = new ErrorDocument(e.getErrorUri(), e.getStatus());
                resp.setStatus(doc.getStatus());
                return;
            }
            String treatment = e.getMessage();
            String verbose = null;
            if (this.config.returnStackTraceInError()) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                verbose = sw.getBuffer().toString();
            }
            ErrorDocument doc = treatment == null ? new ErrorDocument(e.getErrorUri(), e.getStatus(), verbose) : new ErrorDocument(e.getErrorUri(), e.getStatus(), treatment, verbose);
            resp.setStatus(doc.getStatus());
            resp.setHeader("Content-Type", "text/xml");
            doc.writeTo(resp.getWriter(), this.config);
            resp.getWriter().flush();
        }
        catch (SwordServerException sse) {
            throw new ServletException((Throwable)sse);
        }
    }

    protected String getContentDispositionValue(String contentDisposition, String key) {
        if (contentDisposition == null || key == null) {
            return null;
        }
        ParameterParser parameterParser = new ParameterParser();
        char separator = ';';
        Map parameters = parameterParser.parse(contentDisposition, separator);
        return (String)parameters.get(key);
    }

    protected List<FileItem> getPartsFromRequest(HttpServletRequest request) throws ServletException {
        try {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            List items = upload.parseRequest(request);
            return items;
        }
        catch (FileUploadException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected Map<String, String> getAcceptHeaders(HttpServletRequest req) {
        HashMap<String, String> acceptHeaders = new HashMap<String, String>();
        Enumeration headers = req.getHeaderNames();
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            if (!header.toLowerCase().startsWith("accept")) continue;
            acceptHeaders.put(header, req.getHeader(header));
        }
        return acceptHeaders;
    }

    protected void copyInputToOutput(InputStream in, OutputStream out) throws IOException {
        int count;
        int bufferSize = 4096;
        byte[] buffer = new byte[4096];
        while (-1 != (count = in.read(buffer, 0, 4096))) {
            out.write(buffer, 0, count);
        }
    }

    protected String getContentType(HttpServletRequest req) {
        String contentType = req.getHeader("Content-Type");
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        return contentType;
    }

    protected boolean getInProgress(HttpServletRequest req) throws SwordError {
        String iph = req.getHeader("In-Progress");
        boolean inProgress = false;
        if (iph != null) {
            if (!"true".equals(iph.trim()) && !"false".equals(iph.trim())) {
                throw new SwordError("http://purl.org/net/sword/error/ErrorBadRequest", "The In-Progress header MUST be 'true' or 'false'");
            }
            inProgress = "true".equals(iph.trim());
        }
        return inProgress;
    }

    protected boolean getMetadataRelevant(HttpServletRequest req) throws SwordError {
        String mdr = req.getHeader("Metadata-Relevant");
        boolean metadataRelevant = false;
        if (mdr != null) {
            if (!"true".equals(mdr.trim()) && !"false".equals(mdr.trim())) {
                throw new SwordError("http://purl.org/net/sword/error/ErrorBadRequest", "The In-Progress header MUST be 'true' or 'false'");
            }
            metadataRelevant = "true".equals(mdr.trim());
        }
        return metadataRelevant;
    }
}

