/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server;

import java.io.IOException;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swordapp.server.AuthCredentials;
import org.swordapp.server.ChecksumUtils;
import org.swordapp.server.CollectionAPI;
import org.swordapp.server.Statement;
import org.swordapp.server.StatementManager;
import org.swordapp.server.SwordAPIEndpoint;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordConfiguration;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class StatementAPI
extends SwordAPIEndpoint {
    private static Logger log = LoggerFactory.getLogger(CollectionAPI.class);
    private final StatementManager sm;

    public StatementAPI(StatementManager sm, SwordConfiguration config) {
        super(config);
        this.sm = sm;
    }

    @Override
    public void get(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.get(req, resp);
        AuthCredentials auth = null;
        try {
            auth = this.getAuthCredentials(req);
        }
        catch (SwordAuthException e) {
            if (e.isRetry()) {
                String s = "Basic realm=\"SWORD2\"";
                resp.setHeader("WWW-Authenticate", s);
                resp.setStatus(401);
                return;
            }
            resp.sendError(400, e.getMessage());
            return;
        }
        try {
            Map<String, String> accept = this.getAcceptHeaders(req);
            String uri = this.getFullUrl(req);
            Statement statement = this.sm.getStatement(uri, accept, auth, this.config);
            resp.setHeader("Content-Type", statement.getContentType());
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
            Date lastModified = statement.getLastModified() != null ? statement.getLastModified() : new Date();
            resp.setHeader("Last-Modified", sdf.format(lastModified));
            StringWriter writer = new StringWriter();
            statement.writeTo(writer);
            String md5 = ChecksumUtils.hash(writer.toString());
            resp.setHeader("Content-MD5", md5);
            resp.getWriter().append(writer.toString());
            resp.getWriter().flush();
        }
        catch (SwordServerException e) {
            throw new ServletException((Throwable)e);
        }
        catch (SwordError se) {
            this.swordError(req, resp, se);
        }
        catch (SwordAuthException e) {
            resp.sendError(403);
        }
    }
}

