/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.swordapp.server.OriginalDeposit;
import org.swordapp.server.ResourcePart;
import org.swordapp.server.Statement;
import org.swordapp.server.UriRegistry;

public class OREStatement
extends Statement {
    private final String remUri;
    private final String aggUri;

    public OREStatement(String remUri, String aggUri) {
        this.remUri = remUri;
        this.aggUri = aggUri;
        this.contentType = "application/rdf+xml";
    }

    @Override
    public void writeTo(Writer out) throws IOException {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("ore", "http://www.openarchives.org/ore/terms/");
        model.setNsPrefix("sword", "http://purl.org/net/sword/terms/");
        Resource rem = model.createResource(this.remUri);
        rem.addProperty(RDF.type, (RDFNode)model.createResource("http://www.openarchives.org/ore/terms/ResourceMap"));
        Resource agg = model.createResource(this.aggUri);
        agg.addProperty(RDF.type, (RDFNode)model.createResource("http://www.openarchives.org/ore/terms/Aggregation"));
        rem.addProperty(model.createProperty("http://www.openarchives.org/ore/terms/describes"), (RDFNode)agg);
        agg.addProperty(model.createProperty("http://www.openarchives.org/ore/terms/isDescribedBy"), (RDFNode)rem);
        for (ResourcePart resourcePart : this.resources) {
            Resource part = model.createResource(resourcePart.getUri());
            part.addProperty(RDF.type, (RDFNode)model.createResource("http://www.openarchives.org/ore/terms/AggregatedResource"));
            agg.addProperty(model.createProperty("http://www.openarchives.org/ore/terms/aggregates"), (RDFNode)part);
        }
        for (OriginalDeposit originalDeposit : this.originalDeposits) {
            Resource deposit = model.createResource(originalDeposit.getUri());
            deposit.addProperty(RDF.type, (RDFNode)model.createResource("http://www.openarchives.org/ore/terms/AggregatedResource"));
            if (originalDeposit.getDepositedBy() != null) {
                deposit.addLiteral(model.createProperty("http://purl.org/net/sword/terms/depositedBy"), (Object)originalDeposit.getDepositedBy());
            }
            if (originalDeposit.getDepositedOnBehalfOf() != null) {
                deposit.addLiteral(model.createProperty("http://purl.org/net/sword/terms/depositedOnBehalfOf"), (Object)originalDeposit.getDepositedOnBehalfOf());
            }
            if (originalDeposit.getDepositedOn() != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                deposit.addLiteral(model.createProperty("http://purl.org/net/sword/terms/depositedOn"), (Object)sdf.format(originalDeposit.getDepositedOn()));
            }
            for (String packaging : originalDeposit.getPackaging()) {
                deposit.addLiteral(model.createProperty(UriRegistry.SWORD_PACKAGING.toString()), (Object)packaging);
            }
            agg.addProperty(model.createProperty("http://www.openarchives.org/ore/terms/aggregates"), (RDFNode)deposit);
            agg.addProperty(model.createProperty("http://purl.org/net/sword/terms/originalDeposit"), (RDFNode)deposit);
        }
        for (Map.Entry entry : this.states.entrySet()) {
            Resource s = model.createResource((String)entry.getKey());
            if (entry.getValue() != null) {
                s.addProperty(model.createProperty("http://purl.org/net/sword/terms/stateDescription"), (String)entry.getValue());
            }
            agg.addProperty(model.createProperty("http://purl.org/net/sword/terms/state"), (RDFNode)s);
        }
        model.write(out, "RDF/XML");
    }
}

