/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swordapp.server.AuthCredentials;
import org.swordapp.server.Deposit;
import org.swordapp.server.DepositReceipt;
import org.swordapp.server.MediaResource;
import org.swordapp.server.MediaResourceManager;
import org.swordapp.server.SwordAPIEndpoint;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordConfiguration;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class MediaResourceAPI
extends SwordAPIEndpoint {
    private static Logger log = LoggerFactory.getLogger(MediaResourceAPI.class);
    protected final MediaResourceManager mrm;

    public MediaResourceAPI(MediaResourceManager mrm, SwordConfiguration config) {
        super(config);
        this.mrm = mrm;
    }

    @Override
    public void get(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.get(req, resp, true);
    }

    public void get(HttpServletRequest req, HttpServletResponse resp, boolean sendBody) throws ServletException, IOException {
        block18: {
            log.debug("GET on Media Resource URL");
            super.get(req, resp);
            AuthCredentials auth = null;
            try {
                boolean allowUnauthenticated = this.config.allowUnauthenticatedMediaAccess();
                auth = this.getAuthCredentials(req, allowUnauthenticated);
                log.debug("Authentication Credentials extracted: " + auth.getUsername() + " obo: " + auth.getOnBehalfOf());
            }
            catch (SwordAuthException e) {
                if (e.isRetry()) {
                    String s = "Basic realm=\"SWORD2\"";
                    resp.setHeader("WWW-Authenticate", s);
                    resp.setStatus(401);
                    return;
                }
                resp.sendError(400, e.getMessage());
                return;
            }
            try {
                String contentType;
                Map<String, String> acceptHeaders = this.getAcceptHeaders(req);
                String editMediaURI = this.getFullUrl(req);
                MediaResource resource = this.mrm.getMediaResourceRepresentation(editMediaURI, acceptHeaders, auth, this.config);
                if (!resource.isUnpackaged()) {
                    String packaging = resource.getPackaging();
                    if (packaging == null || "".equals(packaging)) {
                        packaging = "http://purl.org/net/sword/package/SimpleZip";
                    }
                    resp.setHeader("Packaging", packaging);
                }
                if ((contentType = resource.getContentType()) == null || "".equals(contentType)) {
                    contentType = "application/octet-stream";
                }
                resp.setHeader("Content-Type", contentType);
                SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
                Date lastModified = resource.getLastModified() != null ? resource.getLastModified() : new Date();
                resp.setHeader("Last-Modified", sdf.format(lastModified));
                String md5 = resource.getContentMD5();
                resp.setHeader("Content-MD5", md5);
                if (!sendBody) break block18;
                ServletOutputStream out = resp.getOutputStream();
                try (InputStream in = resource.getInputStream();){
                    this.copyInputToOutput(in, (OutputStream)out);
                    out.flush();
                }
            }
            catch (SwordError se) {
                this.swordError(req, resp, se);
                return;
            }
            catch (SwordServerException e) {
                throw new ServletException((Throwable)e);
            }
            catch (SwordAuthException e) {
                resp.sendError(403);
            }
        }
    }

    public void head(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.get(req, resp, false);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void put(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void post(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.post(req, resp);
        AuthCredentials auth = null;
        try {
            auth = this.getAuthCredentials(req);
        }
        catch (SwordAuthException e) {
            if (e.isRetry()) {
                String s = "Basic realm=\"SWORD2\"";
                resp.setHeader("WWW-Authenticate", s);
                resp.setStatus(401);
                return;
            }
            resp.sendError(400, e.getMessage());
            return;
        }
        Deposit deposit = null;
        try {
            String contentType = this.getContentType(req);
            boolean isMultipart = contentType.startsWith("multipart/related");
            String uri = this.getFullUrl(req);
            deposit = new Deposit();
            if (isMultipart) {
                this.addDepositPropertiesFromMultipart(deposit, req);
            } else {
                this.addDepositPropertiesFromBinary(deposit, req);
            }
            boolean metadataRelevant = this.getMetadataRelevant(req);
            deposit.setMetadataRelevant(metadataRelevant);
            DepositReceipt receipt = this.mrm.addResource(uri, deposit, auth, this.config);
            IRI location = receipt.getLocation();
            if (location == null) {
                throw new SwordServerException("No Edit-IRI found in Deposit Receipt; unable to send valid response");
            }
            resp.setStatus(201);
            if (this.config.returnDepositReceipt() && !receipt.isEmpty()) {
                this.addGenerator(receipt, this.config);
                resp.setHeader("Content-Type", "application/atom+xml;type=entry");
                resp.setHeader("Location", location.toString());
                Entry responseEntry = receipt.getAbderaEntry();
                responseEntry.writeTo((Writer)resp.getWriter());
                resp.getWriter().flush();
            } else {
                resp.setHeader("Location", location.toString());
            }
            this.cleanup(deposit);
            return;
        }
        catch (SwordError se) {
            this.cleanup(deposit);
            this.swordError(req, resp, se);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (SwordServerException e) {
                throw new ServletException((Throwable)e);
                catch (SwordAuthException e2) {
                    this.cleanup(deposit);
                    resp.sendError(403);
                    return;
                }
            }
        }
        finally {
            this.cleanup(deposit);
        }
    }

    @Override
    public void delete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.delete(req, resp);
        AuthCredentials auth = null;
        try {
            auth = this.getAuthCredentials(req);
        }
        catch (SwordAuthException e) {
            if (e.isRetry()) {
                String s = "Basic realm=\"SWORD2\"";
                resp.setHeader("WWW-Authenticate", s);
                resp.setStatus(401);
                return;
            }
            resp.sendError(400, e.getMessage());
            return;
        }
        try {
            String editMediaIRI = this.getFullUrl(req);
            this.mrm.deleteMediaResource(editMediaIRI, auth, this.config);
            resp.setStatus(204);
        }
        catch (SwordError se) {
            this.swordError(req, resp, se);
        }
        catch (SwordServerException e) {
            throw new ServletException((Throwable)e);
        }
        catch (SwordAuthException e) {
            resp.sendError(403);
        }
    }

    protected void addGenerator(DepositReceipt doc, SwordConfiguration config) {
        Element generator = this.getGenerator(this.config);
        if (generator != null) {
            doc.getWrappedEntry().addExtension(generator);
        }
    }
}

