/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server;

import java.io.Writer;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.swordapp.server.SwordConfiguration;
import org.swordapp.server.SwordServerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ErrorDocument {
    private final String errorUri;
    static final Map<String, Integer> ERROR_CODES = new HashMap<String, Integer>();
    private final String dateUpdated = DateTimeFormatter.ISO_INSTANT.format(ZonedDateTime.now().truncatedTo(ChronoUnit.SECONDS));
    private final String summary;
    private final String verboseDescription;
    private final int status;

    public ErrorDocument(String errorUri) {
        this(errorUri, -1, null, null);
    }

    public ErrorDocument(String errorUri, int status) {
        this(errorUri, status, null, null);
    }

    public ErrorDocument(String errorUri, String verboseDescription) {
        this(errorUri, -1, null, verboseDescription);
    }

    public ErrorDocument(String errorUri, int status, String verboseDescription) {
        this(errorUri, status, null, verboseDescription);
    }

    public ErrorDocument(String errorUri, int status, String summary, String verboseDescription) {
        this.errorUri = errorUri;
        this.summary = summary;
        this.verboseDescription = verboseDescription;
        this.status = status;
    }

    public int getStatus() {
        if (this.status > -1) {
            return this.status;
        }
        if (this.errorUri != null && ERROR_CODES.containsKey(this.errorUri)) {
            return ERROR_CODES.get(this.errorUri);
        }
        return 400;
    }

    String getDateUpdated() {
        return this.dateUpdated;
    }

    public void writeTo(Writer out, SwordConfiguration config) throws SwordServerException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element swordError = doc.createElementNS("http://purl.org/net/sword/terms/", "sword:error");
            swordError.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2005/Atom");
            swordError.setAttribute("href", this.errorUri);
            doc.appendChild(swordError);
            Element title = doc.createElementNS("http://www.w3.org/2005/Atom", "title");
            title.setTextContent("ERROR");
            swordError.appendChild(title);
            Element updated = doc.createElementNS("http://www.w3.org/2005/Atom", "updated");
            updated.setTextContent(this.dateUpdated);
            swordError.appendChild(updated);
            Element generator = doc.createElementNS("http://www.w3.org/2005/Atom", "generator");
            generator.setAttribute("uri", config.generator());
            generator.setAttribute("version", config.generatorVersion());
            if (config.administratorEmail() != null) {
                generator.setTextContent(config.administratorEmail());
            }
            swordError.appendChild(generator);
            if (this.summary != null) {
                Element summary = doc.createElementNS("http://www.w3.org/2005/Atom", "summary");
                summary.setTextContent(this.summary);
                swordError.appendChild(summary);
            }
            String alternate = config.getAlternateUrl();
            String altContentType = config.getAlternateUrlContentType();
            if (alternate != null && !"".equals(alternate)) {
                Element altLink = doc.createElementNS("http://www.w3.org/2005/Atom", "link");
                altLink.setAttribute("rel", "alternate");
                if (altContentType != null && !"".equals(altContentType)) {
                    altLink.setAttribute("type", altContentType);
                }
                altLink.setAttribute("href", alternate);
                swordError.appendChild(altLink);
            }
            Element treatment = doc.createElementNS("http://purl.org/net/sword/terms/", "sword:treatment");
            treatment.setTextContent("Processing failed");
            swordError.appendChild(treatment);
            if (this.verboseDescription != null) {
                Element verbose = doc.createElementNS("http://purl.org/net/sword/terms/", "sword:verboseDescription");
                verbose.setTextContent(this.verboseDescription);
                swordError.appendChild(verbose);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, new StreamResult(out));
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new SwordServerException(e);
        }
    }

    static {
        ERROR_CODES.put("http://purl.org/net/sword/error/ErrorBadRequest", 400);
        ERROR_CODES.put("http://purl.org/net/sword/error/ErrorChecksumMismatch", 412);
        ERROR_CODES.put("http://purl.org/net/sword/error/ErrorContent", 415);
        ERROR_CODES.put("http://purl.org/net/sword/error/MediationNotAllowed", 412);
        ERROR_CODES.put("http://purl.org/net/sword/error/MethodNotAllowed", 405);
        ERROR_CODES.put("http://purl.org/net/sword/error/TargetOwnerUnknown", 403);
        ERROR_CODES.put("http://purl.org/net/sword/error/MaxUploadSizeExceeded", 413);
    }
}

