/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swordapp.server.AuthCredentials;
import org.swordapp.server.ChecksumUtils;
import org.swordapp.server.ContainerManager;
import org.swordapp.server.Deposit;
import org.swordapp.server.DepositReceipt;
import org.swordapp.server.Statement;
import org.swordapp.server.StatementManager;
import org.swordapp.server.SwordAPIEndpoint;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordConfiguration;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class ContainerAPI
extends SwordAPIEndpoint {
    private static Logger log = LoggerFactory.getLogger(ContainerAPI.class);
    private final ContainerManager cm;
    private final StatementManager sm;

    public ContainerAPI(ContainerManager cm, StatementManager sm, SwordConfiguration config) {
        super(config);
        this.cm = cm;
        this.sm = sm;
    }

    @Override
    public void get(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.get(req, resp, true);
    }

    public void get(HttpServletRequest req, HttpServletResponse resp, boolean sendBody) throws ServletException, IOException {
        super.get(req, resp);
        AuthCredentials auth = null;
        try {
            auth = this.getAuthCredentials(req);
        }
        catch (SwordAuthException e) {
            if (e.isRetry()) {
                String s = "Basic realm=\"SWORD2\"";
                resp.setHeader("WWW-Authenticate", s);
                resp.setStatus(401);
                return;
            }
            resp.sendError(400, e.getMessage());
            return;
        }
        try {
            Map<String, String> accept = this.getAcceptHeaders(req);
            String iri = this.getFullUrl(req);
            if (this.cm.isStatementRequest(iri, accept, auth, this.config)) {
                Statement statement = this.sm.getStatement(iri, accept, auth, this.config);
                resp.setHeader("Content-Type", statement.getContentType());
                SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
                Date lastModified = statement.getLastModified() != null ? statement.getLastModified() : new Date();
                resp.setHeader("Last-Modified", sdf.format(lastModified));
                StringWriter writer = new StringWriter();
                statement.writeTo(writer);
                String md5 = ChecksumUtils.hash(writer.toString());
                resp.setHeader("Content-MD5", md5);
                if (sendBody) {
                    resp.getWriter().append(writer.toString());
                    resp.getWriter().flush();
                }
            } else {
                DepositReceipt receipt = this.cm.getEntry(iri, accept, auth, this.config);
                this.addGenerator(receipt, this.config);
                IRI location = receipt.getLocation();
                resp.setHeader("Content-Type", "application/atom+xml;type=entry");
                resp.setHeader("Location", location.toString());
                SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
                Date lastModified = receipt.getLastModified() != null ? receipt.getLastModified() : new Date();
                resp.setHeader("Last-Modified", sdf.format(lastModified));
                StringWriter writer = new StringWriter();
                Entry responseEntry = receipt.getAbderaEntry();
                responseEntry.writeTo((Writer)writer);
                String md5 = ChecksumUtils.hash(writer.toString());
                resp.setHeader("Content-MD5", md5);
                if (sendBody) {
                    resp.getWriter().append(writer.toString());
                    resp.getWriter().flush();
                }
            }
        }
        catch (SwordError se) {
            this.swordError(req, resp, se);
        }
        catch (SwordServerException e) {
            throw new ServletException((Throwable)e);
        }
        catch (SwordAuthException e) {
            resp.sendError(403);
        }
    }

    public void head(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.get(req, resp, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void put(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.put(req, resp);
        AuthCredentials auth = null;
        try {
            auth = this.getAuthCredentials(req);
        }
        catch (SwordAuthException e) {
            if (e.isRetry()) {
                String s = "Basic realm=\"SWORD2\"";
                resp.setHeader("WWW-Authenticate", s);
                resp.setStatus(401);
                return;
            }
            resp.sendError(400, e.getMessage());
            return;
        }
        Deposit deposit = null;
        try {
            DepositReceipt receipt;
            String contentType = this.getContentType(req);
            boolean isMultipart = contentType.startsWith("multipart/related");
            boolean isEntryOnly = contentType.startsWith("application/atom+xml");
            boolean inProgress = this.getInProgress(req);
            deposit = new Deposit();
            deposit.setInProgress(inProgress);
            String iri = this.getFullUrl(req);
            if (isMultipart) {
                this.addDepositPropertiesFromMultipart(deposit, req);
                receipt = this.cm.replaceMetadataAndMediaResource(iri, deposit, auth, this.config);
            } else {
                if (!isEntryOnly) throw new SwordError("http://purl.org/net/sword/error/ErrorBadRequest", "PUT to Edit-IRI MUST be a multipart request or an Atom Entry");
                if (!contentType.startsWith("application/atom+xml") && !contentType.startsWith("application/atom+xml;type=entry")) {
                    throw new SwordError("http://purl.org/net/sword/error/ErrorBadRequest", "Content-Type must be 'application/atom+xml' or 'application/atom+xml;type=entry'");
                }
                this.addDepositPropertiesFromEntry(deposit, req);
                receipt = this.cm.replaceMetadata(iri, deposit, auth, this.config);
            }
            IRI location = receipt.getLocation();
            if (location == null) {
                throw new SwordServerException("No Location found in Deposit Receipt; unable to send valid response");
            }
            if (this.config.returnDepositReceipt() && !receipt.isEmpty()) {
                this.addGenerator(receipt, this.config);
                resp.setStatus(200);
                resp.setHeader("Content-Type", "application/atom+xml;type=entry");
                resp.setHeader("Location", location.toString());
                SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
                Date lastModified = receipt.getLastModified() != null ? receipt.getLastModified() : new Date();
                resp.setHeader("Last-Modified", sdf.format(lastModified));
                StringWriter writer = new StringWriter();
                Entry responseEntry = receipt.getAbderaEntry();
                responseEntry.writeTo((Writer)writer);
                String md5 = ChecksumUtils.hash(writer.toString());
                resp.setHeader("Content-MD5", md5);
                resp.getWriter().append(writer.toString());
                resp.getWriter().flush();
            } else {
                resp.setStatus(204);
                resp.setHeader("Location", location.toString());
            }
            this.cleanup(deposit);
            return;
        }
        catch (SwordError se) {
            this.cleanup(deposit);
            this.swordError(req, resp, se);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (SwordServerException e) {
                throw new ServletException((Throwable)e);
                catch (SwordAuthException e2) {
                    this.cleanup(deposit);
                    resp.sendError(403);
                    return;
                }
            }
        }
        finally {
            this.cleanup(deposit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void post(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.post(req, resp);
        AuthCredentials auth = null;
        try {
            auth = this.getAuthCredentials(req);
        }
        catch (SwordAuthException e) {
            if (e.isRetry()) {
                String s = "Basic realm=\"SWORD2\"";
                resp.setHeader("WWW-Authenticate", s);
                resp.setStatus(401);
                return;
            }
            resp.sendError(400, e.getMessage());
            return;
        }
        Deposit deposit = null;
        try {
            DepositReceipt receipt;
            String contentType = this.getContentType(req);
            boolean isEntryOnly = contentType.startsWith("application/atom+xml");
            int contentLength = req.getContentLength();
            boolean headersOnly = contentLength == 0;
            boolean inProgress = this.getInProgress(req);
            String iri = this.getFullUrl(req);
            deposit = new Deposit();
            deposit.setInProgress(inProgress);
            if (isEntryOnly) {
                this.addDepositPropertiesFromEntry(deposit, req);
                receipt = this.cm.addMetadata(iri, deposit, auth, this.config);
            } else if (headersOnly) {
                receipt = this.cm.useHeaders(iri, deposit, auth, this.config);
            } else {
                this.addDepositPropertiesFromBinary(deposit, req);
                receipt = this.cm.addResources(iri, deposit, auth, this.config);
            }
            IRI location = receipt.getLocation();
            if (this.config.returnDepositReceipt() && !receipt.isEmpty()) {
                this.addGenerator(receipt, this.config);
                resp.setHeader("Content-Type", "application/atom+xml;type=entry");
                if (location != null) {
                    resp.setHeader("Location", location.toString());
                }
                SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
                Date lastModified = receipt.getLastModified() != null ? receipt.getLastModified() : new Date();
                resp.setHeader("Last-Modified", sdf.format(lastModified));
                StringWriter writer = new StringWriter();
                Entry responseEntry = receipt.getAbderaEntry();
                responseEntry.writeTo((Writer)writer);
                String md5 = ChecksumUtils.hash(writer.toString());
                resp.setHeader("Content-MD5", md5);
                resp.getWriter().append(writer.toString());
                resp.getWriter().flush();
            } else if (location != null) {
                resp.setHeader("Location", location.toString());
            }
            this.cleanup(deposit);
            return;
        }
        catch (SwordError se) {
            this.cleanup(deposit);
            this.swordError(req, resp, se);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (SwordServerException e) {
                throw new ServletException((Throwable)e);
                catch (SwordAuthException e2) {
                    this.cleanup(deposit);
                    resp.sendError(403);
                    return;
                }
            }
        }
        finally {
            this.cleanup(deposit);
        }
    }

    @Override
    public void delete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.delete(req, resp);
        AuthCredentials auth = null;
        try {
            auth = this.getAuthCredentials(req);
        }
        catch (SwordAuthException e) {
            if (e.isRetry()) {
                String s = "Basic realm=\"SWORD2\"";
                resp.setHeader("WWW-Authenticate", s);
                resp.setStatus(401);
                return;
            }
            resp.sendError(400, e.getMessage());
            return;
        }
        try {
            String uri = this.getFullUrl(req);
            this.cm.deleteContainer(uri, auth, this.config);
            resp.setStatus(204);
        }
        catch (SwordError se) {
            this.swordError(req, resp, se);
        }
        catch (SwordServerException e) {
            throw new ServletException((Throwable)e);
        }
        catch (SwordAuthException e) {
            resp.sendError(403);
        }
    }

    protected void addGenerator(DepositReceipt doc, SwordConfiguration config) {
        Element generator = this.getGenerator(this.config);
        if (generator != null) {
            doc.getWrappedEntry().addExtension(generator);
        }
    }
}

