/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Feed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swordapp.server.AuthCredentials;
import org.swordapp.server.CollectionDepositManager;
import org.swordapp.server.CollectionListManager;
import org.swordapp.server.DepositReceipt;
import org.swordapp.server.SwordAPIEndpoint;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordConfiguration;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class CollectionAPI
extends SwordAPIEndpoint {
    private static Logger log = LoggerFactory.getLogger(CollectionAPI.class);
    protected final CollectionListManager clm;
    protected final CollectionDepositManager cdm;

    public CollectionAPI(CollectionListManager clm, CollectionDepositManager cdm, SwordConfiguration config) {
        super(config);
        this.clm = clm;
        this.cdm = cdm;
    }

    @Override
    public void get(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.get(req, resp);
        if (this.clm == null) {
            resp.sendError(405);
            return;
        }
        AuthCredentials auth = null;
        try {
            auth = this.getAuthCredentials(req);
        }
        catch (SwordAuthException e) {
            if (e.isRetry()) {
                String s = "Basic realm=\"SWORD2\"";
                resp.setHeader("WWW-Authenticate", s);
                resp.setStatus(401);
                return;
            }
            resp.sendError(400, e.getMessage());
            return;
        }
        try {
            Feed feed = this.clm.listCollectionContents(new IRI(this.getFullUrl(req)), auth, this.config);
            if (feed == null) {
                resp.sendError(405, "This server does not support listing collection contents");
                return;
            }
            this.addGenerator(feed, this.config);
            resp.setHeader("Content-Type", "application/atom+xml;type=feed");
            feed.writeTo((Writer)resp.getWriter());
            resp.getWriter().flush();
        }
        catch (SwordServerException e) {
            throw new ServletException((Throwable)e);
        }
        catch (SwordAuthException e) {
            resp.sendError(403);
        }
        catch (SwordError se) {
            this.swordError(req, resp, se);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void post(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void addGenerator(DepositReceipt doc, SwordConfiguration config) {
        Element generator = this.getGenerator(this.config);
        if (generator != null) {
            doc.getWrappedEntry().addExtension(generator);
        }
    }

    protected void addGenerator(Feed doc, SwordConfiguration config) {
        Element generator = this.getGenerator(this.config);
        if (generator != null) {
            doc.addExtension(generator);
        }
    }
}

