/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChecksumUtils {
    private static Logger log = LoggerFactory.getLogger(ChecksumUtils.class);
    private static MessageDigest md;
    private static final int LARGE_BUFFER = 0x100000;
    private static final int SMALL_BUFFER = 1024;

    private ChecksumUtils() {
    }

    public static String hashAndCopy(InputStream input, OutputStream output) throws IOException {
        if (md == null) {
            throw new IllegalStateException("Cannot generate hash value as the digest is not available.");
        }
        md.reset();
        try (DigestOutputStream digestStream = new DigestOutputStream(output, md);){
            ReadableByteChannel in = Channels.newChannel(input);
            WritableByteChannel out = Channels.newChannel(digestStream);
            ByteBuffer buffer = ByteBuffer.allocate(0x100000);
            while (in.read(buffer) != -1) {
                buffer.flip();
                out.write(buffer);
                buffer.compact();
            }
        }
        return ChecksumUtils.formatAsHex(md.digest());
    }

    public static String hash(String s) {
        if (md == null) {
            throw new IllegalStateException("Cannot generate hash value as the digest is not available.");
        }
        md.reset();
        return ChecksumUtils.formatAsHex(md.digest(s.getBytes(StandardCharsets.UTF_8)));
    }

    private static String formatAsHex(byte[] digest) {
        return String.format("%032x", new BigInteger(1, digest));
    }

    static {
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Cannot load MD5 digest from this JVM.", (Throwable)e);
        }
    }
}

