/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Category;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.swordapp.server.OriginalDeposit;
import org.swordapp.server.ResourcePart;
import org.swordapp.server.Statement;
import org.swordapp.server.UriRegistry;

public class AtomStatement
extends Statement {
    private final String author;
    private final String feedUri;
    private final String title;
    private final String updated;

    public AtomStatement(String feedUri, String author, String title, String updated) {
        this.contentType = "application/atom+xml;type=feed";
        this.author = author != null && !"".equals(author) ? author : "Unknown";
        this.feedUri = feedUri;
        this.title = title != null ? title : "Untitled";
        this.updated = updated;
    }

    @Override
    public void writeTo(Writer out) throws IOException {
        Entry entry;
        Abdera abdera = new Abdera();
        Feed feed = abdera.newFeed();
        feed.setId(this.feedUri);
        feed.addLink(this.feedUri, "self");
        feed.setTitle(this.title);
        feed.addAuthor(this.author);
        if (this.updated != null) {
            feed.setUpdated(this.updated);
        } else {
            feed.setUpdated(new Date());
        }
        for (ResourcePart resourcePart : this.resources) {
            entry = feed.addEntry();
            entry.setContent(new IRI(resourcePart.getUri()), resourcePart.getMediaType());
            entry.setId(resourcePart.getUri());
            entry.setTitle("Resource " + resourcePart.getUri());
            entry.setSummary("Resource Part");
            entry.setUpdated(new Date());
            for (String linkHref : resourcePart.getSelfLinks()) {
                entry.addLink(linkHref, "self");
            }
        }
        for (OriginalDeposit originalDeposit : this.originalDeposits) {
            entry = feed.addEntry();
            entry.setId(originalDeposit.getUri());
            entry.setTitle("Original Deposit " + originalDeposit.getUri());
            entry.setSummary("Original Deposit");
            entry.setUpdated(new Date());
            for (String linkHref : originalDeposit.getSelfLinks()) {
                entry.addLink(linkHref, "self");
            }
            if (originalDeposit.getMediaType() != null) {
                entry.setContent(new IRI(originalDeposit.getUri()), originalDeposit.getMediaType());
            }
            entry.addCategory("http://purl.org/net/sword/terms/", "http://purl.org/net/sword/terms/originalDeposit", "Original Deposit");
            if (originalDeposit.getDepositedOn() != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                entry.addSimpleExtension(new QName("http://purl.org/net/sword/terms/depositedOn"), sdf.format(originalDeposit.getDepositedOn()));
            }
            if (originalDeposit.getDepositedOnBehalfOf() != null) {
                entry.addSimpleExtension(new QName("http://purl.org/net/sword/terms/depositedOnBehalfOf"), originalDeposit.getDepositedOnBehalfOf());
            }
            if (originalDeposit.getDepositedBy() != null) {
                entry.addSimpleExtension(new QName("http://purl.org/net/sword/terms/depositedBy"), originalDeposit.getDepositedBy());
            }
            if (originalDeposit.getPackaging() == null) continue;
            for (String packaging : originalDeposit.getPackaging()) {
                entry.addSimpleExtension(UriRegistry.SWORD_PACKAGING, packaging);
            }
        }
        for (Map.Entry entry2 : this.states.entrySet()) {
            Category cat = feed.addCategory("http://purl.org/net/sword/terms/state", (String)entry2.getKey(), "State");
            if (entry2.getValue() == null) continue;
            cat.setText((String)entry2.getValue());
        }
        feed.writeTo(out);
    }
}

