/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.oauth;

import io.gatling.http.client.Request;
import io.gatling.http.client.SignatureCalculator;
import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.form.FormUrlEncodedRequestBody;
import io.gatling.http.client.oauth.ConsumerKey;
import io.gatling.http.client.oauth.OAuthSignatureCalculatorInstance;
import io.gatling.http.client.oauth.RequestToken;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.Collections;
import java.util.List;

class StaticOAuthSignatureCalculator
implements SignatureCalculator {
    private final ConsumerKey consumerKey;
    private final RequestToken requestToken;
    private final String nonce;
    private final long timestamp;

    StaticOAuthSignatureCalculator(ConsumerKey consumerKey, RequestToken requestToken, String string, long l) {
        this.consumerKey = consumerKey;
        this.requestToken = requestToken;
        this.nonce = string;
        this.timestamp = l;
    }

    @Override
    public void sign(Request request) throws Exception {
        RequestBody requestBody = request.getBody();
        List list = requestBody instanceof FormUrlEncodedRequestBody ? (List)((FormUrlEncodedRequestBody)requestBody).getContent() : Collections.emptyList();
        String string = new OAuthSignatureCalculatorInstance().computeAuthorizationHeader(this.consumerKey, this.requestToken, request.getMethod(), request.getUri(), list, this.timestamp, this.nonce);
        request.getHeaders().set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)string);
    }
}

