/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.bytearrays;

import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.WritableContent;
import io.gatling.http.client.body.bytearrays.ByteArraysRequestBodyBuilder;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;

public class ByteArraysRequestBody
extends RequestBody<byte[][]> {
    private final long contentLength;

    public ByteArraysRequestBody(byte[][] byArray, String string, Charset charset) {
        super(byArray, string, charset);
        long l = 0L;
        for (byte[] byArray2 : byArray) {
            l += (long)byArray2.length;
        }
        this.contentLength = l;
    }

    @Override
    public WritableContent build(boolean bl, ByteBufAllocator byteBufAllocator) {
        return new WritableContent(Unpooled.wrappedBuffer((byte[][])((byte[][])this.content)), this.contentLength);
    }

    @Override
    public RequestBodyBuilder<byte[][]> newBuilder() {
        return new ByteArraysRequestBodyBuilder((byte[][])this.content);
    }

    @Override
    public byte[] getBytes() {
        byte[] byArray = new byte[(int)this.contentLength];
        int n = 0;
        for (byte[] byArray2 : (byte[][])this.content) {
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            n += byArray2.length;
        }
        return byArray;
    }

    public String toString() {
        return "ByteArraysRequestBody{content=<" + this.contentLength + " bytes>, contentType=" + this.contentType + ", charset=" + this.charset + '}';
    }
}

