package io.gamedock.sdk.ads.utils.device;

import android.content.Context;

/**
 * Class used to convert density and pixel values.
 */
public class DensityUtil {
    /**
     * Method used to convert Density Points (DP) to Pixels (PX).
     * @param context
     * @param dpValue
     * @return
     */
    public static int dpToPx(Context context, float dpValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (dpValue * scale + 0.5f);
    }

    /**
     * Method used to convert Pixels (PX) to Density Points (DP).
     * @param context
     * @param pxValue
     * @return
     */
    public static int pxToDp(Context context, float pxValue) {
        final float scale =  context.getResources().getDisplayMetrics().density;
        return (int) (pxValue / scale + 0.5f);
    }
}
