package io.gamedock.sdk.ads.core.base.web;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.webkit.WebView;

import androidx.annotation.RequiresApi;

/**
 * Class that extends the the general WebView class to add some additional logic.
 */
public class AdWebView extends WebView {
    private ViewGroup viewGroup;

    public AdWebView(Context context) {
        super(context);
    }

    public AdWebView(Context context, ViewGroup viewGroup) {
        super(context);
        this.viewGroup = viewGroup;
    }

    public AdWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AdWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public AdWebView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public boolean overScrollBy(int deltaX, int deltaY, int scrollX, int scrollY, int scrollRangeX, int scrollRangeY, int maxOverScrollX, int maxOverScrollY, boolean isTouchEvent) {
        return false;
    }

    @Override
    public void scrollTo(int x, int y) {
        // Do nothing
    }

    @Override
    public void computeScroll() {
        // Do nothing
    }
}
