package io.gamedock.sdk.ads.core.base;

import io.gamedock.sdk.ads.providers.AdProvider;

/**
 * Base class containing general logic for all the ad types.
 */
public abstract class BaseAd {
    protected String[] placementIds;
    protected AdProvider provider;
    protected AdData adData;

    protected boolean isLoading;
    protected boolean isLoaded;

    public BaseAd(AdProvider provider, String[] placementIds) {
        this.placementIds = placementIds;
        this.provider = provider;
    }

    public String[] getPlacementIds() {
        return placementIds;
    }

    public void setPlacementIds(String[] placementIds) {
        this.placementIds = placementIds;
    }

    public AdProvider getProvider() {
        return provider;
    }

    public AdData getAdData() {
        return adData;
    }

    public boolean isLoading() {
        return isLoading;
    }

    public void setLoading(boolean loading) {
        isLoading = loading;
    }

    public boolean isLoaded() {
        return isLoaded;
    }

    public void setLoaded(boolean loaded) {
        isLoaded = loaded;
    }

    public abstract void load();

    public abstract void show();
}
