package io.gamedock.sdk.ads.providers.improvedigital;

import android.content.Context;
import android.net.Uri;

import io.gamedock.sdk.ads.GamedockAds;
import io.gamedock.sdk.ads.core.banner.BannerAdSize;
import io.gamedock.sdk.ads.core.request.AdType;
import io.gamedock.sdk.ads.core.request.BaseRequest;
import io.gamedock.sdk.ads.core.request.RequestListener;
import io.gamedock.sdk.ads.core.request.RequestType;
import io.gamedock.sdk.ads.utils.connectivity.ConnectivityInfo;
import io.gamedock.sdk.ads.utils.device.DensityUtil;
import io.gamedock.sdk.ads.utils.device.DeviceInfo;

/**
 * Class that implements the Improve Digital Request logic.
 */
public class ImproveDigitalRequest extends BaseRequest {
    private static final String BASE_URL_NON_VAST = "https://ad.360yield.com/adm";
    private static final String BASE_URL_VAST = "https://ad.360yield.com/advast";

    private String placementId;
    private BannerAdSize bannerAdSize;

    public ImproveDigitalRequest(Context context, String placementId, AdType adType, RequestType requestType, RequestListener requestListener, BannerAdSize bannerAdSize) {
        super(context, adType, requestType, requestListener);
        this.placementId = placementId;
        this.bannerAdSize = bannerAdSize;
    }

    @Override
    public String getUrl() {
        if (placementId == null || placementId.isEmpty()) {
            return "";
        }

        switch (requestType) {
            case INIT:
                break;
            case STATIC:
                return Uri.parse(BASE_URL_NON_VAST)
                        .buildUpon()
                        .appendQueryParameter("p", placementId)
                        .appendQueryParameter("w", String.valueOf((bannerAdSize != null ? bannerAdSize.getWidth(context) : 1)))
                        .appendQueryParameter("h", String.valueOf((bannerAdSize != null ? bannerAdSize.getHeight(context) : 1)))
                        .appendQueryParameter("ifa", DeviceInfo.getAdvertisingId())
                        .appendQueryParameter("bundle", DeviceInfo.getPackageName())
                        .appendQueryParameter("carrier", ConnectivityInfo.retrieveCarrier(context))
                        .appendQueryParameter("conn_speed", ConnectivityInfo.retrieveConnectionSpeed(context))
                        .appendQueryParameter("lmt", String.valueOf((GamedockAds.getInstance().getSettings().isWithUserConsent() ? 1 : 0)))
                        .appendQueryParameter("devicew", String.valueOf(DeviceInfo.getDeviceWidth()))
                        .appendQueryParameter("deviceh", String.valueOf(DeviceInfo.getDeviceHeight()))
                        .appendQueryParameter("density", DeviceInfo.getDeviceDensity())
                        .appendQueryParameter("densityvalue", String.valueOf(DeviceInfo.getDeviceDensityValue()))
                        .appendQueryParameter("os", DeviceInfo.getOs())
                        .appendQueryParameter("osv", DeviceInfo.getOsVersion())
                        .appendQueryParameter("make", DeviceInfo.getDeviceManufacturer())
                        .appendQueryParameter("model", DeviceInfo.getDeviceModel())
                        .appendQueryParameter("devicetype", String.valueOf(DeviceInfo.getDeviceType()))
                        .appendQueryParameter("gdpr", String.valueOf((GamedockAds.getInstance().getSettings().isWithUserConsent() ? 1 : 0)))
                        .build()
                        .toString();
            case VAST:
                return Uri.parse(BASE_URL_VAST)
                        .buildUpon()
                        .appendQueryParameter("p", placementId)
                        .appendQueryParameter("w", String.valueOf(DensityUtil.pxToDp(context, DeviceInfo.getDeviceWidth())))
                        .appendQueryParameter("h", String.valueOf(DensityUtil.pxToDp(context, DeviceInfo.getDeviceHeight())))
                        .appendQueryParameter("ifa", DeviceInfo.getAdvertisingId())
                        .appendQueryParameter("bundle", DeviceInfo.getPackageName())
                        .appendQueryParameter("carrier", ConnectivityInfo.retrieveCarrier(context))
                        .appendQueryParameter("conn_speed", ConnectivityInfo.retrieveConnectionSpeed(context))
                        .appendQueryParameter("lmt", String.valueOf((GamedockAds.getInstance().getSettings().isWithUserConsent() ? 1 : 0)))
                        .appendQueryParameter("devicew", String.valueOf(DeviceInfo.getDeviceWidth()))
                        .appendQueryParameter("deviceh", String.valueOf(DeviceInfo.getDeviceHeight()))
                        .appendQueryParameter("density", DeviceInfo.getDeviceDensity())
                        .appendQueryParameter("densityvalue", String.valueOf(DeviceInfo.getDeviceDensityValue()))
                        .appendQueryParameter("minduration", DeviceInfo.getVastMinDuration())
                        .appendQueryParameter("maxduration", DeviceInfo.getVastMaxDuration())
                        .appendQueryParameter("player_width", String.valueOf(DeviceInfo.getDeviceWidth()))
                        .appendQueryParameter("player_height", String.valueOf(DeviceInfo.getDeviceHeight()))
                        .appendQueryParameter("referrer", DeviceInfo.getReferrerUrl())
                        .appendQueryParameter("vast_version", DeviceInfo.getVastVersion())
                        .appendQueryParameter("video_format_type", DeviceInfo.getVastFormatType())
                        .appendQueryParameter("os", DeviceInfo.getOs())
                        .appendQueryParameter("osv", DeviceInfo.getOsVersion())
                        .appendQueryParameter("make", DeviceInfo.getDeviceManufacturer())
                        .appendQueryParameter("model", DeviceInfo.getDeviceModel())
                        .appendQueryParameter("devicetype", String.valueOf(DeviceInfo.getDeviceType()))
                        .appendQueryParameter("gdpr", String.valueOf((GamedockAds.getInstance().getSettings().isWithUserConsent() ? 1 : 0)))
                        .build()
                        .toString();
        }
        return "";
    }
}
